/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GCScheme;
import g4p_controls.GConstants;
import g4p_controls.GConstantsInternal;
import g4p_controls.GControlMode;
import g4p_controls.GEvent;
import g4p_controls.GMessenger;
import g4p_controls.HotSpot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import processing.awt.PGraphicsJava2D;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public abstract class GAbstractControl
implements PConstants,
GConstants,
GConstantsInternal {
    static GAbstractControl focusIsWith = null;
    static GAbstractControl controlToTakeFocus = null;
    static GAbstractControl cursorIsOver;
    protected PApplet winApp;
    protected int z = 0;
    protected boolean dragging = false;
    protected static float epsilon;
    protected GAbstractControl parent = null;
    protected LinkedList<GAbstractControl> children = null;
    protected int localColorScheme = G4P.globalColorScheme;
    protected Color[] palette = null;
    protected int alphaLevel = G4P.globalAlpha;
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    protected float halfWidth;
    protected float halfHeight;
    protected float cx;
    protected float cy;
    protected float rotAngle;
    protected double[] temp = new double[2];
    protected PGraphicsJava2D buffer = null;
    protected boolean bufferInvalid = true;
    protected boolean opaque = false;
    protected int cursorOver = 12;
    protected float ox;
    protected float oy;
    public String tag = "";
    public int tagNo;
    boolean visible = true;
    boolean enabled = true;
    boolean available = true;
    protected Object eventHandlerObject = null;
    protected Method eventHandlerMethod = null;
    protected String eventHandlerMethodName;
    protected int registeredMethods = 0;
    protected HotSpot[] hotspots = null;
    protected int currSpot = -1;

    public GAbstractControl(PApplet pApplet) {
        G4P.registerSketch(pApplet);
        this.winApp = pApplet;
        GCScheme.makeColorSchemes(this.winApp);
        this.rotAngle = 0.0f;
        this.z = 0;
        this.palette = GCScheme.getJavaColor(this.localColorScheme);
    }

    public GAbstractControl(PApplet pApplet, float f, float f2) {
        this(pApplet);
        switch (G4P.control_mode) {
            case CORNER: 
            case CORNERS: {
                this.x = f;
                this.y = f2;
                break;
            }
            case CENTER: {
                this.cx = f;
                this.cy = f2;
            }
        }
    }

    public GAbstractControl(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet);
        this.setPositionAndSize(f, f2, f3, f4);
        this.buffer = (PGraphicsJava2D)this.winApp.createGraphics((int)this.width, (int)this.height, "processing.awt.PGraphicsJava2D");
        this.buffer.rectMode(0);
        this.buffer.beginDraw();
        this.buffer.endDraw();
    }

    protected void setTextRenderingHints(Graphics2D graphics2D, int n) {
        if (n == 0) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            return;
        }
        switch (n) {
            case 1: {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                break;
            }
            case 2: {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
                break;
            }
            case 3: {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                break;
            }
            default: {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
        }
    }

    private void setPositionAndSize(float f, float f2, float f3, float f4) {
        switch (G4P.control_mode) {
            case CORNER: {
                this.x = f;
                this.y = f2;
                this.width = f3;
                this.height = f4;
                this.halfWidth = this.width / 2.0f;
                this.halfHeight = this.height / 2.0f;
                this.cx = this.x + this.halfWidth;
                this.cy = this.y + this.halfHeight;
                break;
            }
            case CORNERS: {
                this.x = f;
                this.y = f2;
                this.width = f3 - f;
                this.height = f4 - f2;
                this.halfWidth = this.width / 2.0f;
                this.halfHeight = this.height / 2.0f;
                this.cx = this.x + this.halfWidth;
                this.cy = this.y + this.halfHeight;
                break;
            }
            case CENTER: {
                this.cx = f;
                this.cy = f2;
                this.width = f3;
                this.height = f4;
                this.halfWidth = this.width / 2.0f;
                this.halfHeight = this.height / 2.0f;
                this.x = this.cx - this.halfWidth;
                this.y = this.cy - this.halfHeight;
            }
        }
    }

    protected void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.halfWidth = this.width / 2.0f;
        this.halfHeight = this.height / 2.0f;
        switch (G4P.control_mode) {
            case CORNER: 
            case CORNERS: {
                this.cx = this.x + this.halfWidth;
                this.cy = this.y + this.halfHeight;
                break;
            }
            case CENTER: {
                this.x = this.cx - this.halfWidth;
                this.y = this.cy - this.halfHeight;
            }
        }
        this.buffer = (PGraphicsJava2D)this.winApp.createGraphics(n, n2, "processing.awt.PGraphicsJava2D");
        this.buffer.rectMode(0);
    }

    protected boolean isSuitableForGroupControl(GAbstractControl gAbstractControl) {
        return (0xB & this.registeredMethods) != 0;
    }

    public void draw() {
    }

    public void mouseEvent(MouseEvent mouseEvent) {
    }

    public void keyEvent(KeyEvent keyEvent) {
    }

    public void pre() {
    }

    public void post() {
    }

    public void dispose() {
        G4P.removeControl(this);
    }

    public void forceBufferUpdate() {
        this.bufferInvalid = true;
    }

    protected int whichHotSpot(float f, float f2) {
        if (this.hotspots == null) {
            return -1;
        }
        int n = -1;
        for (int i = 0; i < this.hotspots.length; ++i) {
            if (!this.hotspots[i].contains(f, f2)) continue;
            n = this.hotspots[i].id;
            break;
        }
        return n;
    }

    protected int getCurrHotSpot() {
        return this.currSpot;
    }

    public boolean isOver(float f, float f2) {
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        return this.currSpot >= 0;
    }

    public void setLocalColor(int n, int n2) {
        if (this.localColorScheme >= 0) {
            int[] nArray = GCScheme.getPalette(this.localColorScheme);
            this.palette = new Color[16];
            for (int i = 0; i < 16; ++i) {
                this.palette[i] = new Color(nArray[i], true);
            }
            this.localColorScheme = -1;
        }
        n = Math.abs(n) % 16;
        this.palette[n] = new Color(n2, true);
        this.bufferInvalid = true;
    }

    public void setLocalColorScheme(int n) {
        this.setLocalColorScheme(n, false);
    }

    public void setLocalColorScheme(int n, boolean bl) {
        if (this.localColorScheme != (n = Math.abs(n) % 16) || this.palette == null) {
            this.localColorScheme = n;
            this.palette = GCScheme.getJavaColor(this.localColorScheme);
            this.bufferInvalid = true;
            if (bl && this.children != null) {
                for (GAbstractControl gAbstractControl : this.children) {
                    gAbstractControl.setLocalColorScheme(n, true);
                }
            }
        }
    }

    public int getLocalColorScheme() {
        return this.localColorScheme;
    }

    public void setAlpha(int n) {
        if (this.alphaLevel != (n = Math.abs(n) % 256)) {
            this.alphaLevel = n;
            this.available = this.alphaLevel >= 128;
            this.bufferInvalid = true;
        }
    }

    public void setAlpha(int n, boolean bl) {
        this.setAlpha(n);
        if (bl && this.children != null) {
            for (GAbstractControl gAbstractControl : this.children) {
                gAbstractControl.setAlpha(n, true);
            }
        }
    }

    public GAbstractControl getParent() {
        return this.parent;
    }

    public PApplet getPApplet() {
        return this.winApp;
    }

    protected PGraphics getBuffer() {
        return this.buffer;
    }

    protected boolean isDisplayable(int n) {
        return n >= 32 && n != 127;
    }

    public PGraphics getSnapshot() {
        if (this.buffer != null) {
            this.updateBuffer();
            PGraphics pGraphics = this.winApp.createGraphics(this.buffer.width, this.buffer.height, "processing.awt.PGraphicsJava2D");
            pGraphics.beginDraw();
            pGraphics.image((PImage)this.buffer, 0.0f, 0.0f);
            pGraphics.endDraw();
            return pGraphics;
        }
        return null;
    }

    public boolean saveSnapshot() {
        String string = this.getClass().getSimpleName().toLowerCase() + "_" + System.currentTimeMillis() + ".png";
        return this.saveSnapshot(string);
    }

    public boolean saveSnapshot(String string) {
        PGraphics pGraphics = this.getSnapshot();
        if (pGraphics != null) {
            pGraphics.save(string);
            return true;
        }
        return false;
    }

    protected void updateBuffer() {
    }

    protected void createEventHandler(Object object, String string, Class[] classArray, String[] stringArray) {
        try {
            this.eventHandlerMethod = object.getClass().getMethod(string, classArray);
            this.eventHandlerObject = object;
            this.eventHandlerMethodName = string;
        }
        catch (Exception exception) {
            GMessenger.message(-16777215, new Object[]{this, string, classArray, stringArray});
            this.eventHandlerObject = null;
        }
    }

    public void addEventHandler(Object object, String string) {
        try {
            this.eventHandlerObject = object;
            this.eventHandlerMethodName = string;
            this.eventHandlerMethod = object.getClass().getMethod(string, this.getClass(), GEvent.class);
        }
        catch (Exception exception) {
            GMessenger.message(-16777214, new Object[]{this, string, new Class[]{this.getClass(), GEvent.class}});
            this.eventHandlerObject = null;
            this.eventHandlerMethodName = "";
        }
    }

    protected void fireEvent(Object ... objectArray) {
        if (this.eventHandlerMethod != null) {
            try {
                this.eventHandlerMethod.invoke(this.eventHandlerObject, objectArray);
            }
            catch (Exception exception) {
                GMessenger.message(-16777211, new Object[]{this.eventHandlerObject, this.eventHandlerMethodName, exception});
            }
        }
    }

    public void setRotation(float f) {
        this.setRotation(f, G4P.control_mode);
    }

    public void setRotation(float f, GControlMode gControlMode) {
        this.rotAngle = f;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(f);
        switch (gControlMode) {
            case CORNER: 
            case CORNERS: {
                this.temp[0] = this.halfWidth;
                this.temp[1] = this.halfHeight;
                affineTransform.transform(this.temp, 0, this.temp, 0, 1);
                this.cx = (float)this.temp[0] + this.x;
                this.cy = (float)this.temp[1] + this.y;
                break;
            }
            default: {
                this.temp[0] = -this.halfWidth;
                this.temp[1] = -this.halfHeight;
                affineTransform.transform(this.temp, 0, this.temp, 0, 1);
                this.x = this.cx + (float)this.temp[0];
                this.y = this.cy + (float)this.temp[1];
            }
        }
    }

    public void moveTo(float f, float f2) {
        this.moveTo(f, f2, G4P.control_mode);
    }

    public void moveTo(float f, float f2, GControlMode gControlMode) {
        GAbstractControl gAbstractControl = this.parent;
        if (gAbstractControl != null) {
            f -= gAbstractControl.width / 2.0f;
            f2 -= gAbstractControl.height / 2.0f;
        }
        switch (gControlMode) {
            case CORNER: 
            case CORNERS: {
                this.cx += f - this.x;
                this.cy += f2 - this.y;
                this.x = this.cx - this.width / 2.0f;
                this.y = this.cy - this.height / 2.0f;
                break;
            }
            case CENTER: {
                this.cx = f;
                this.cy = f2;
                this.x = this.cx - this.width / 2.0f;
                this.y = this.cy - this.height / 2.0f;
            }
        }
    }

    public float getX() {
        if (this.parent != null) {
            return this.x + this.parent.width / 2.0f;
        }
        return this.x;
    }

    public float getY() {
        if (this.parent != null) {
            return this.y + this.parent.height / 2.0f;
        }
        return this.y;
    }

    public float getCX() {
        if (this.parent != null) {
            return this.x + (this.parent.width + this.width) / 2.0f;
        }
        return this.cx;
    }

    public float getCY() {
        if (this.parent != null) {
            return this.x + (this.parent.width + this.width) / 2.0f;
        }
        return this.cy;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setVisible(boolean bl) {
        if (!bl && focusIsWith == this) {
            this.loseFocus(null);
        }
        this.visible = bl;
        this.available = bl ? this.alphaLevel > 128 : false;
        if (this.children != null) {
            for (GAbstractControl gAbstractControl : this.children) {
                gAbstractControl.setAvailable(this.visible);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void setAvailable(boolean bl) {
        this.available = bl;
        if (this.children != null) {
            for (GAbstractControl gAbstractControl : this.children) {
                gAbstractControl.setAvailable(bl);
            }
        }
    }

    protected boolean isAvailable() {
        return this.available;
    }

    public void setOpaque(boolean bl) {
        this.bufferInvalid |= bl != this.opaque;
        this.opaque = bl;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.children != null) {
            for (GAbstractControl gAbstractControl : this.children) {
                gAbstractControl.setEnabled(bl);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void takeFocus() {
        if (focusIsWith != null && focusIsWith != this) {
            focusIsWith.loseFocus(this);
        }
        focusIsWith = this;
    }

    protected void loseFocus(GAbstractControl gAbstractControl) {
        if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        focusIsWith = gAbstractControl;
        this.bufferInvalid = true;
    }

    public void setFocus(boolean bl) {
        if (bl) {
            this.takeFocus();
        } else {
            this.loseFocus(null);
        }
    }

    public boolean hasFocus() {
        return this == focusIsWith;
    }

    protected static int focusObjectZ() {
        return focusIsWith == null ? -1 : GAbstractControl.focusIsWith.z;
    }

    public void addControl(GAbstractControl gAbstractControl, float f, float f2, float f3) {
        if (this.children == null) {
            return;
        }
        gAbstractControl.rotAngle = f3;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(f3);
        switch (G4P.control_mode) {
            case CORNER: 
            case CORNERS: {
                gAbstractControl.x = f;
                gAbstractControl.y = f2;
                gAbstractControl.temp[0] = gAbstractControl.halfWidth;
                gAbstractControl.temp[1] = gAbstractControl.halfHeight;
                affineTransform.transform(gAbstractControl.temp, 0, gAbstractControl.temp, 0, 1);
                gAbstractControl.cx = (float)gAbstractControl.temp[0] + f - this.halfWidth;
                gAbstractControl.cy = (float)gAbstractControl.temp[1] + f2 - this.halfHeight;
                gAbstractControl.x = gAbstractControl.cx - gAbstractControl.halfWidth;
                gAbstractControl.y = gAbstractControl.cy - gAbstractControl.halfHeight;
                break;
            }
            case CENTER: {
                gAbstractControl.cx = f;
                gAbstractControl.cy = f2;
                gAbstractControl.temp[0] = -gAbstractControl.halfWidth;
                gAbstractControl.temp[1] = -gAbstractControl.halfHeight;
                affineTransform.transform(gAbstractControl.temp, 0, gAbstractControl.temp, 0, 1);
                gAbstractControl.x = gAbstractControl.cx + (float)gAbstractControl.temp[0] - this.halfWidth;
                gAbstractControl.y = gAbstractControl.cy - (float)gAbstractControl.temp[1] - this.halfHeight;
                gAbstractControl.cx -= this.halfWidth;
                gAbstractControl.cy -= this.halfHeight;
            }
        }
        gAbstractControl.rotAngle = f3;
        gAbstractControl.parent = this;
        gAbstractControl.setZ(this.z);
        gAbstractControl.registeredMethods &= 0x1E;
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.addLast(gAbstractControl);
        Collections.sort(this.children, new Z_Order());
        gAbstractControl.addToParent(this);
    }

    public void addControl(GAbstractControl gAbstractControl, float f, float f2) {
        if (this.children == null) {
            return;
        }
        this.addControl(gAbstractControl, f, f2, 0.0f);
    }

    public void addControl(GAbstractControl gAbstractControl) {
        if (this.children == null) {
            return;
        }
        switch (G4P.control_mode) {
            case CORNER: 
            case CORNERS: {
                this.addControl(gAbstractControl, gAbstractControl.x, gAbstractControl.y, gAbstractControl.rotAngle);
                break;
            }
            case CENTER: {
                this.addControl(gAbstractControl, gAbstractControl.cx, gAbstractControl.cy, gAbstractControl.rotAngle);
            }
        }
    }

    public void addControls(GAbstractControl ... gAbstractControlArray) {
        if (this.children == null) {
            return;
        }
        block4: for (GAbstractControl gAbstractControl : gAbstractControlArray) {
            switch (G4P.control_mode) {
                case CORNER: 
                case CORNERS: {
                    this.addControl(gAbstractControl, gAbstractControl.x, gAbstractControl.y, gAbstractControl.rotAngle);
                    continue block4;
                }
                case CENTER: {
                    this.addControl(gAbstractControl, gAbstractControl.cx, gAbstractControl.cy, gAbstractControl.rotAngle);
                }
            }
        }
    }

    protected void addToParent(GAbstractControl gAbstractControl) {
    }

    public int getCursorOver() {
        return this.cursorOver;
    }

    public void setCursorOver(int n) {
        this.cursorOver = n;
    }

    protected AffineTransform getTransform(AffineTransform affineTransform) {
        if (this.parent != null) {
            affineTransform = this.parent.getTransform(affineTransform);
        }
        affineTransform.translate(this.cx, this.cy);
        affineTransform.rotate(this.rotAngle);
        return affineTransform;
    }

    protected void calcTransformedOrigin(float f, float f2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform = this.getTransform(affineTransform);
        this.temp[0] = f;
        this.temp[1] = f2;
        try {
            affineTransform.inverseTransform(this.temp, 0, this.temp, 0, 1);
            this.ox = (float)this.temp[0] + this.halfWidth;
            this.oy = (float)this.temp[1] + this.halfHeight;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    protected void setZ(int n) {
        this.z += n;
        if (this.children != null) {
            for (GAbstractControl gAbstractControl : this.children) {
                gAbstractControl.setZ(n);
            }
        }
    }

    public void markForDisposal() {
        G4P.removeControl(this);
    }

    public String toString() {
        if (this.tag == null) {
            return this.getClass().getSimpleName();
        }
        return this.tag;
    }

    static {
        epsilon = 0.001f;
    }

    public static class Z_Order
    implements Comparator<GAbstractControl> {
        @Override
        public int compare(GAbstractControl gAbstractControl, GAbstractControl gAbstractControl2) {
            if (gAbstractControl.z != gAbstractControl2.z) {
                return new Integer(gAbstractControl.z).compareTo(new Integer(gAbstractControl2.z));
            }
            return new Integer((int)(-gAbstractControl.y)).compareTo(new Integer((int)(-gAbstractControl2.y)));
        }
    }
}

