/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GButton;
import g4p_controls.GControlMode;
import g4p_controls.GEvent;
import g4p_controls.GScrollbar;
import g4p_controls.GTextBase;
import g4p_controls.HotSpot;
import g4p_controls.StyledString;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.MouseEvent;

public class GDropList
extends GTextBase {
    protected static int LIST_SURFACE = 1;
    protected static int CLOSED_SURFACE = 2;
    protected static final int FORE_COLOR = 2;
    protected static final int BACK_COLOR = 5;
    protected static final int ITEM_FORE_COLOR = 3;
    protected static final int ITEM_BACK_COLOR = 6;
    protected static final int OVER_ITEM_FORE_COLOR = 15;
    private GScrollbar vsb;
    private GButton showList;
    protected LinkedList<String> itemlist = new LinkedList();
    protected StyledString[] sitems;
    protected StyledString selText;
    protected int selItem = 0;
    protected int startItem = 0;
    protected int lastOverItem;
    protected int currOverItem = this.lastOverItem = -1;
    protected int dropListMaxSize = 4;
    protected int dropListActualSize = 4;
    protected float itemHeight;
    protected float buttonWidth;
    protected boolean expanded = false;

    public GDropList(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, 4);
    }

    public GDropList(PApplet pApplet, float f, float f2, float f3, float f4, int n) {
        super(pApplet, f, f2, f3, f4);
        this.children = new LinkedList();
        this.dropListMaxSize = Math.max(n, 3);
        this.itemHeight = this.height / (float)(n + 1);
        G4P.pushStyle();
        G4P.showMessages = false;
        this.vsb = new GScrollbar(pApplet, 0.0f, 0.0f, this.height - this.itemHeight - 2.0f, 10.0f);
        this.vsb.addEventHandler(this, "vsbEventHandler");
        this.vsb.setAutoHide(true);
        this.vsb.setVisible(false);
        this.buttonWidth = 10.0f;
        this.showList = new GButton(pApplet, 0.0f, 0.0f, this.buttonWidth, this.itemHeight, ":");
        this.showList.addEventHandler(this, "buttonShowListHandler");
        this.z = 48;
        G4P.control_mode = GControlMode.CORNER;
        this.addControl(this.vsb, this.width, this.itemHeight + 1.0f, 1.5707964f);
        this.addControl(this.showList, this.width - this.buttonWidth, 0.0f, 0.0f);
        G4P.popStyle();
        this.hotspots = new HotSpot[]{new HotSpot.HSrect(LIST_SURFACE, 0.0f, this.itemHeight + 1.0f, this.width - 11.0f, this.height - this.itemHeight - 1.0f), new HotSpot.HSrect(CLOSED_SURFACE, 0.0f, 0.0f, this.width - this.buttonWidth, this.itemHeight)};
        this.createEventHandler(G4P.sketchWindow, "handleDropListEvents", new Class[]{GDropList.class, GEvent.class}, new String[]{"list", "event"});
        this.registeredMethods = 3;
        this.cursorOver = 12;
        G4P.registerControl(this);
    }

    public void setItems(String[] stringArray, int n) {
        if (stringArray == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            arrayList.add(string);
        }
        if (this.cleanupList(arrayList)) {
            this.setItemsImpl(n);
        }
    }

    public void setItems(List<String> list, int n) {
        if (list == null) {
            return;
        }
        if (this.cleanupList(list)) {
            this.setItemsImpl(n);
        }
    }

    private boolean cleanupList(List<String> list) {
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string != null && string.length() != 0) continue;
            iterator.remove();
        }
        if (list.size() > 0) {
            this.itemlist.clear();
            this.itemlist.addAll(list);
            return true;
        }
        return false;
    }

    private void setItemsImpl(int n) {
        this.sitems = new StyledString[this.itemlist.size()];
        for (int i = 0; i < this.sitems.length; ++i) {
            this.sitems[i] = new StyledString(this.itemlist.get(i));
        }
        this.selItem = PApplet.constrain((int)n, (int)0, (int)(this.sitems.length - 1));
        this.startItem = this.selItem >= this.dropListMaxSize ? this.selItem - this.dropListMaxSize + 1 : 0;
        this.sitems[this.selItem].addAttribute(WEIGHT, WEIGHT_BOLD);
        this.selText = new StyledString(this.sitems[this.selItem].getPlainText());
        this.dropListActualSize = Math.min(this.sitems.length, this.dropListMaxSize);
        if (this.sitems.length > this.dropListActualSize) {
            float f = (float)this.dropListMaxSize / (float)this.sitems.length;
            float f2 = (float)this.startItem / (float)this.sitems.length;
            this.vsb.setValue(f2, f);
            this.vsb.setVisible(false);
        }
        this.bufferInvalid = true;
    }

    public boolean removeItem(int n) {
        if (this.itemlist.size() <= 1 || n < 0 || n >= this.itemlist.size()) {
            return false;
        }
        int n2 = n > this.selItem ? this.selItem : this.selItem - 1;
        this.itemlist.remove(n);
        this.setItemsImpl(n2);
        return true;
    }

    public boolean insertItem(int n, String string) {
        if (n < 0 || string == null || string.length() > 0) {
            return false;
        }
        if (n >= this.itemlist.size()) {
            this.itemlist.addLast(string);
        } else {
            this.itemlist.add(n, string);
        }
        int n2 = n <= this.selItem ? this.selItem + 1 : this.selItem;
        this.setItemsImpl(n2);
        return true;
    }

    public boolean addItem(String string) {
        if (string == null) {
            return false;
        }
        this.itemlist.addLast(string);
        return true;
    }

    public void setSelected(int n) {
        if (n >= 0 && n < this.sitems.length) {
            this.selItem = n;
            this.startItem = this.selItem >= this.dropListMaxSize ? this.selItem - this.dropListMaxSize + 1 : 0;
            for (StyledString styledString : this.sitems) {
                styledString.clearAttributes();
            }
            this.sitems[this.selItem].addAttribute(WEIGHT, WEIGHT_BOLD);
            this.selText = new StyledString(this.sitems[this.selItem].getPlainText());
            this.bufferInvalid = true;
        }
    }

    public int getSelectedIndex() {
        return this.selItem;
    }

    public String getSelectedText() {
        return this.sitems[this.selItem].getPlainText();
    }

    @Override
    public void setLocalColorScheme(int n) {
        super.setLocalColorScheme(n);
        if (this.showList != null) {
            this.showList.setLocalColorScheme(this.localColorScheme);
        }
        if (this.vsb != null) {
            this.vsb.setLocalColorScheme(this.localColorScheme);
        }
    }

    @Override
    public boolean isOver(float f, float f2) {
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        return !this.expanded ? this.currSpot == CLOSED_SURFACE : this.currSpot == CLOSED_SURFACE | this.currSpot == LIST_SURFACE;
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot >= 0 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 3: {
                if (focusIsWith != this) break;
                this.loseFocus(null);
                this.vsb.setVisible(false);
                this.expanded = false;
                this.bufferInvalid = true;
                if (this.currOverItem >= 0 && this.currOverItem != this.selItem) {
                    this.setSelected(this.currOverItem);
                    this.fireEvent(new Object[]{this, GEvent.SELECTED});
                }
                this.lastOverItem = -1;
                this.currOverItem = -1;
                break;
            }
            case 5: {
                if (focusIsWith != this) break;
                this.currOverItem = this.currSpot == LIST_SURFACE ? this.startItem + (int)(this.oy / this.itemHeight) - 1 : -1;
                if (this.currOverItem == this.lastOverItem) break;
                this.lastOverItem = this.currOverItem;
                this.bufferInvalid = true;
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.pushMatrix();
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        this.winApp.popMatrix();
        if (this.children != null) {
            for (GAbstractControl gAbstractControl : this.children) {
                gAbstractControl.draw();
            }
        }
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    public PGraphics getSnapshot() {
        this.updateBuffer();
        PGraphics pGraphics = this.winApp.createGraphics(this.buffer.width, this.buffer.height, "processing.awt.PGraphicsJava2D");
        pGraphics.beginDraw();
        pGraphics.image((PImage)this.buffer, 0.0f, 0.0f);
        pGraphics.pushMatrix();
        pGraphics.image((PImage)this.showList.getBuffer(), this.width - this.showList.getWidth() - 1.0f, 1.0f);
        pGraphics.translate(this.width, this.itemHeight + 1.0f);
        pGraphics.rotate(1.5707964f);
        pGraphics.image((PImage)this.vsb.getBuffer(), 0.0f, 0.0f);
        pGraphics.popMatrix();
        pGraphics.endDraw();
        return pGraphics;
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            Graphics2D graphics2D = this.buffer.g2;
            graphics2D.setFont(this.localFont);
            this.buffer.clear();
            this.buffer.noStroke();
            this.buffer.fill(this.palette[5].getRGB());
            this.buffer.rect(0.0f, 0.0f, this.width, this.itemHeight);
            if (this.expanded) {
                this.buffer.fill(this.palette[6].getRGB());
                this.buffer.rect(0.0f, this.itemHeight, this.width, this.itemHeight * (float)this.dropListActualSize);
            }
            float f = 2.0f;
            TextLayout textLayout = this.selText.getLines((Graphics2D)graphics2D).getFirst().layout;
            float f2 = (this.itemHeight + textLayout.getAscent() - textLayout.getDescent()) / 2.0f;
            graphics2D.setColor(this.palette[2]);
            textLayout.draw(graphics2D, f, f2);
            if (this.expanded) {
                for (int i = 0; i < this.dropListActualSize; ++i) {
                    f2 += this.itemHeight;
                    if (this.currOverItem == this.startItem + i) {
                        graphics2D.setColor(this.palette[15]);
                    } else {
                        graphics2D.setColor(this.palette[3]);
                    }
                    textLayout = this.sitems[this.startItem + i].getLines((Graphics2D)graphics2D).getFirst().layout;
                    textLayout.draw(graphics2D, f, f2);
                }
            }
            this.buffer.endDraw();
        }
    }

    @Override
    protected void loseFocus(GAbstractControl gAbstractControl) {
        if (gAbstractControl != this.vsb) {
            this.expanded = false;
            this.vsb.setVisible(false);
            this.bufferInvalid = true;
        }
        if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        focusIsWith = gAbstractControl;
    }

    public void vsbEventHandler(GScrollbar gScrollbar, GEvent gEvent) {
        int n;
        this.startItem = n = Math.round(this.vsb.getValue() * (float)this.sitems.length);
        this.bufferInvalid = true;
    }

    public void buttonShowListHandler(GButton gButton, GEvent gEvent) {
        if (this.expanded) {
            this.loseFocus(null);
            this.vsb.setVisible(false);
            this.expanded = false;
        } else {
            this.takeFocus();
            this.vsb.setVisible(this.sitems.length > this.dropListActualSize);
            this.expanded = true;
        }
        this.bufferInvalid = true;
    }
}

