/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GEvent;
import g4p_controls.GValueControl;
import g4p_controls.HotSpot;
import processing.core.PApplet;
import processing.core.PImage;
import processing.event.MouseEvent;

public class GKnob
extends GValueControl {
    protected float startAng = 110.0f;
    protected float endAng = 70.0f;
    protected int mode = 1282;
    protected boolean showTrack = true;
    protected float bezelRadius = Math.min(this.width, this.height) / 2.0f - 2.0f;
    protected float bezelWidth;
    protected float gripRadius;
    protected boolean overIncludesBezel = true;
    protected float sensitivity = 1.0f;
    protected boolean drawArcOnly = false;
    protected boolean mouseOverArcOnly = false;
    protected float startMouseX;
    protected float startMouseY;
    protected float lastMouseAngle;
    protected float mouseAngle;
    protected float angleTarget;
    protected float lastAngleTarget;

    public GKnob(PApplet pApplet, float f, float f2, float f3, float f4, float f5) {
        super(pApplet, f, f2, f3, f4);
        this.setGripAmount(f5);
        this.setTurnRange(this.startAng, this.endAng);
        this.lastAngleTarget = this.angleTarget = this.scaleValueToAngle(this.parametricTarget);
        this.hotspots = new HotSpot[]{new HotSpot.HScircle(1, this.width / 2.0f, this.height / 2.0f, this.gripRadius)};
        this.z = 24;
        epsilon = 0.98f / (this.endAng - this.startAng);
        this.showTicks = true;
        this.createEventHandler(G4P.sketchWindow, "handleKnobEvents", new Class[]{GValueControl.class, GEvent.class}, new String[]{"knob", "event"});
        this.registeredMethods = 7;
        this.cursorOver = 12;
        G4P.registerControl(this);
    }

    public void setGripAmount(float f) {
        f = PApplet.constrain((float)f, (float)0.0f, (float)1.0f);
        this.gripRadius = this.bezelRadius * f;
        if (this.gripRadius < 2.0f) {
            this.gripRadius = 0.0f;
        }
        this.bezelWidth = this.bezelRadius - this.gripRadius;
        this.bufferInvalid = true;
    }

    protected void calculateHotSpot() {
        float f = this.overIncludesBezel ? this.bezelRadius : this.gripRadius;
        this.hotspots[0] = this.mouseOverArcOnly ? new HotSpot.HSarc(1, this.width / 2.0f, this.height / 2.0f, f, this.startAng, this.endAng) : new HotSpot.HScircle(1, this.width / 2.0f, this.height / 2.0f, f);
    }

    protected float scaleValueToAngle(float f) {
        float f2 = this.startAng + f * (this.endAng - this.startAng);
        return f2;
    }

    protected float calcAngletoValue(float f) {
        if (f < this.startAng) {
            f += 360.0f;
        }
        float f2 = (f - this.startAng) / (this.endAng - this.startAng);
        return f2;
    }

    @Override
    public void setValue(float f) {
        super.setValue(f);
        this.angleTarget = this.scaleValueToAngle(this.parametricTarget);
    }

    public void setShowTrack(boolean bl) {
        if (this.showTrack != bl) {
            this.showTrack = bl;
            this.bufferInvalid = true;
        }
    }

    public boolean isShowTrack() {
        return this.showTrack;
    }

    public void setIncludeOverBezel(boolean bl) {
        this.overIncludesBezel = bl;
        this.calculateHotSpot();
    }

    public boolean isIncludeOverBezel() {
        return this.overIncludesBezel;
    }

    public void setOverArcOnly(boolean bl) {
        this.mouseOverArcOnly = bl;
        this.calculateHotSpot();
    }

    public boolean isOverArcOnly() {
        return this.mouseOverArcOnly;
    }

    public void setArcPolicy(boolean bl, boolean bl2, boolean bl3) {
        this.mouseOverArcOnly = bl;
        this.setShowArcOnly(bl2);
        this.overIncludesBezel = bl3;
        this.calculateHotSpot();
    }

    public void setShowArcOnly(boolean bl) {
        if (this.drawArcOnly != bl) {
            this.drawArcOnly = bl;
            this.bufferInvalid = true;
        }
    }

    public boolean isShowArcOnly() {
        return this.drawArcOnly;
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        this.ox -= this.width / 2.0f;
        this.oy -= this.height / 2.0f;
        if (this.currSpot >= 0 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (focusIsWith == this || this.currSpot <= -1 || this.z <= GKnob.focusObjectZ()) break;
                this.startMouseX = this.ox;
                this.startMouseY = this.oy;
                this.lastMouseAngle = this.mouseAngle = this.getAngleFromUser(this.ox, this.oy);
                this.offset = this.scaleValueToAngle(this.parametricTarget) - this.mouseAngle;
                this.takeFocus();
                break;
            }
            case 8: {
                if (this.currSpot <= -1 || this.z < GKnob.focusObjectZ()) break;
                System.out.print(this.tag + "  " + this.parametricTarget + "  " + mouseEvent.getCount() + "   " + this.wheelDelta + "     >>>  ");
                this.parametricTarget = this.calcParametricTarget(this.parametricTarget + (float)mouseEvent.getCount() * this.wheelDelta * (float)G4P.wheelForSlider);
                System.out.println(this.parametricTarget);
                break;
            }
            case 2: {
                if (focusIsWith == this) {
                    this.loseFocus(null);
                }
                if (this.stickToTicks) {
                    this.parametricTarget = this.findNearestTickValueTo(this.parametricTarget);
                }
                this.dragging = false;
                break;
            }
            case 4: {
                if (focusIsWith != this) break;
                this.mouseAngle = this.getAngleFromUser(this.ox, this.oy);
                if (this.mouseAngle == this.lastMouseAngle) break;
                float f = this.mouseAngle - this.lastMouseAngle;
                if (f < -180.0f) {
                    f += 360.0f;
                } else if (f > 180.0f) {
                    f -= 360.0f;
                }
                this.angleTarget = this.constrainToTurnRange(this.angleTarget + f);
                this.parametricTarget = this.calcAngletoValue(this.angleTarget);
                this.offset += this.angleTarget - this.lastAngleTarget - f;
                this.lastAngleTarget = this.angleTarget;
                this.lastMouseAngle = this.mouseAngle;
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.pushMatrix();
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        this.winApp.popMatrix();
        if (this.children != null) {
            for (GAbstractControl gAbstractControl : this.children) {
                gAbstractControl.draw();
            }
        }
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            double d;
            double d2;
            double d3;
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            this.buffer.ellipseMode(3);
            if (this.opaque) {
                this.buffer.background(this.palette[6].getRGB());
            } else {
                this.buffer.background(this.buffer.color(255, 0));
            }
            this.buffer.translate(this.width / 2.0f, this.height / 2.0f);
            this.buffer.noStroke();
            float f = this.scaleValueToAngle(this.parametricPos);
            if (this.bezelWidth > 0.0f) {
                this.buffer.noStroke();
                this.buffer.fill(this.palette[5].getRGB());
                if (this.drawArcOnly) {
                    this.buffer.arc(0.0f, 0.0f, 2.0f * this.bezelRadius, 2.0f * this.bezelRadius, PApplet.radians((float)this.startAng), PApplet.radians((float)this.endAng));
                } else {
                    this.buffer.ellipse(0.0f, 0.0f, 2.0f * this.bezelRadius, 2.0f * this.bezelRadius);
                }
                if (this.showTicks) {
                    this.buffer.noFill();
                    this.buffer.strokeWeight(1.6f);
                    this.buffer.stroke(this.palette[3].getRGB());
                    float f2 = (this.endAng - this.startAng) / (float)(this.nbrTicks - 1);
                    for (int i = 0; i < this.nbrTicks; ++i) {
                        float f3 = this.gripRadius + (i == 0 || i == this.nbrTicks - 1 ? this.bezelWidth : this.bezelWidth * 0.8f);
                        d3 = Math.toRadians(this.startAng + (float)i * f2);
                        d2 = Math.sin(d3);
                        d = Math.cos(d3);
                        this.buffer.line((float)((double)this.gripRadius * d), (float)((double)this.gripRadius * d2), (float)((double)f3 * d), (float)((double)f3 * d2));
                    }
                }
                if (this.showTrack) {
                    this.buffer.noStroke();
                    this.buffer.fill(this.palette[14].getRGB());
                    this.buffer.arc(0.0f, 0.0f, 2.0f * (this.gripRadius + this.bezelWidth * 0.5f), 2.0f * (this.gripRadius + this.bezelWidth * 0.5f), PApplet.radians((float)this.startAng), PApplet.radians((float)f));
                }
            }
            this.buffer.strokeWeight(1.6f);
            this.buffer.stroke(this.palette[2].getRGB());
            this.buffer.fill(this.palette[2].getRGB());
            if (this.drawArcOnly) {
                this.buffer.arc(0.0f, 0.0f, 2.0f * this.gripRadius, 2.0f * this.gripRadius, PApplet.radians((float)this.startAng), PApplet.radians((float)this.endAng));
            } else {
                this.buffer.ellipse(0.0f, 0.0f, 2.0f * this.gripRadius, 2.0f * this.gripRadius);
            }
            this.buffer.noFill();
            this.buffer.stroke(this.palette[14].getRGB());
            this.buffer.strokeWeight(3.0f);
            d3 = Math.toRadians(f);
            d2 = Math.sin(d3);
            d = Math.cos(d3);
            this.buffer.line(0.0f, 0.0f, (float)((double)this.gripRadius * d), (float)((double)this.gripRadius * d2));
            this.buffer.endDraw();
        }
    }

    public int getTurnMode() {
        return this.mode;
    }

    public void setTurnMode(int n) {
        switch (n) {
            case 1281: 
            case 1282: 
            case 1283: {
                this.mode = n;
            }
        }
    }

    public float getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(float f) {
        this.sensitivity = f < 0.1f ? 0.1f : f;
    }

    protected float getAngleFromUser(float f, float f2) {
        float f3 = 0.0f;
        switch (this.mode) {
            case 1281: {
                f3 = this.calcRealAngleFromXY(this.ox, this.oy);
                break;
            }
            case 1282: {
                f3 = this.sensitivity * (f - this.startMouseX);
                break;
            }
            case 1283: {
                f3 = this.sensitivity * (f2 - this.startMouseY);
            }
        }
        return f3;
    }

    public void setTurnRange(float f, float f2) {
        f = this.constrain360(f);
        f2 = this.constrain360(f2);
        this.startAng = f;
        this.endAng = this.startAng >= f2 ? f2 + 360.0f : f2;
        this.setValue(this.getValueF());
        this.bufferInvalid = true;
    }

    protected boolean isInTurnRange(float f) {
        if ((f = this.constrain360(f)) < this.startAng) {
            f += 360.0f;
        }
        return f >= this.startAng && f <= this.endAng;
    }

    protected float constrainToTurnRange(float f) {
        if (f < this.startAng) {
            f = this.startAng;
        } else if (f > this.endAng) {
            f = this.endAng;
        }
        return f;
    }

    protected float constrain360(float f) {
        while (f < 0.0f) {
            f += 360.0f;
        }
        while (f > 360.0f) {
            f -= 360.0f;
        }
        return f;
    }

    protected float calcRealAngleFromXY(float f, float f2) {
        float f3 = (float)Math.toDegrees(Math.atan2(f2, f));
        if (f3 < 0.0f) {
            f3 += 360.0f;
        }
        return f3;
    }
}

