/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GClip;
import g4p_controls.GControlMode;
import g4p_controls.GEditableTextControl;
import g4p_controls.GEvent;
import g4p_controls.GScrollbar;
import g4p_controls.HotSpot;
import g4p_controls.StyledString;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.MouseEvent;

public class GTextArea
extends GEditableTextControl {
    protected boolean newline = false;
    protected boolean backspace = false;

    public GTextArea(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, 0, Integer.MAX_VALUE);
    }

    public GTextArea(PApplet pApplet, float f, float f2, float f3, float f4, int n) {
        this(pApplet, f, f2, f3, f4, n, Integer.MAX_VALUE);
    }

    public GTextArea(PApplet pApplet, float f, float f2, float f3, float f4, int n, int n2) {
        super(pApplet, f, f2, f3, f4, n);
        this.children = new LinkedList();
        this.ty = 6.0f;
        this.tx = 6.0f;
        this.tw = this.width - 12.0f - (float)((this.scrollbarPolicy & 1) != 0 ? 18 : 0);
        this.th = this.height - 12.0f - (float)((this.scrollbarPolicy & 2) != 0 ? 18 : 0);
        this.wrapWidth = n2 == Integer.MAX_VALUE ? (int)this.tw : n2;
        this.gpTextDisplayArea = new GeneralPath();
        this.gpTextDisplayArea.moveTo(0.0f, 0.0f);
        this.gpTextDisplayArea.lineTo(0.0f, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, 0.0f);
        this.gpTextDisplayArea.closePath();
        this.hotspots = new HotSpot[]{new HotSpot.HSrect(1, this.tx, this.ty, this.tw, this.th), new HotSpot.HSrect(9, 0.0f, 0.0f, this.width, this.height)};
        G4P.pushStyle();
        G4P.showMessages = false;
        this.z = 0;
        G4P.control_mode = GControlMode.CORNER;
        if ((this.scrollbarPolicy & 2) != 0) {
            this.hsb = new GScrollbar(pApplet, 0.0f, 0.0f, this.tw, 16.0f);
            this.addControl(this.hsb, this.tx, this.ty + this.th + 2.0f, 0.0f);
            this.hsb.addEventHandler(this, "hsbEventHandler");
            this.hsb.setAutoHide(this.autoHide);
        }
        if ((this.scrollbarPolicy & 1) != 0) {
            this.vsb = new GScrollbar(pApplet, 0.0f, 0.0f, this.th, 16.0f);
            this.addControl(this.vsb, this.tx + this.tw + 18.0f, this.ty, 1.5707964f);
            this.vsb.addEventHandler(this, "vsbEventHandler");
            this.vsb.setAutoHide(this.autoHide);
        }
        this.setScrollbarValues(0.0f, 0.0f);
        G4P.popStyle();
        this.setText("");
        this.createEventHandler(G4P.sketchWindow, "handleTextEvents", new Class[]{GEditableTextControl.class, GEvent.class}, new String[]{"textcontrol", "event"});
        this.registeredMethods = 15;
        G4P.registerControl(this);
        this.bufferInvalid = true;
    }

    protected void setTextImpl(String string, int n) {
        if (string != null) {
            string = string.length() > 0 ? string : " ";
            this.stext.setText(string, n);
            this.setStyledText(this.stext);
            this.bufferInvalid = true;
        }
    }

    public void setText(String string, int n) {
        this.setTextImpl(string, n);
    }

    @Override
    public void setText(String string) {
        this.setTextImpl(string, this.wrapWidth);
    }

    public void setText(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.setTextImpl(PApplet.join((String[])stringArray, (String)"\n"), this.wrapWidth);
        }
    }

    public void setText(String[] stringArray, int n) {
        if (stringArray != null && stringArray.length > 0) {
            this.setTextImpl(PApplet.join((String[])stringArray, (String)"\n"), n);
        }
    }

    public String[] getTextAsArray() {
        return this.stext.getPlainTextAsArray();
    }

    public void addStyle(TextAttribute textAttribute, Object object, int n, int n2, int n3) {
        this.stext.addAttribute(textAttribute, object, n, n2, n3);
        this.bufferInvalid = true;
    }

    public void addStyle(TextAttribute textAttribute, Object object, int n) {
        this.stext.addAttribute(textAttribute, object, n);
        this.bufferInvalid = true;
    }

    public void clearStyles(int n, int n2, int n3) {
        this.stext.clearAttributes(n, n2, n3);
        this.bufferInvalid = true;
    }

    public void clearStyles(int n) {
        this.stext.clearAttributes(n);
        this.bufferInvalid = true;
    }

    @Override
    public void setStyledText(StyledString styledString) {
        this.stext = styledString;
        if (this.stext.getWrapWidth() == Integer.MAX_VALUE) {
            this.stext.setWrapWidth(this.wrapWidth);
        } else {
            this.wrapWidth = this.stext.getWrapWidth();
        }
        this.stext.getLines(this.buffer.g2);
        if (this.stext.getNbrLines() > 0) {
            this.endTLHI.tli = this.stext.getLines(this.buffer.g2).getFirst();
            this.endTLHI.thi = this.endTLHI.tli.layout.getNextLeftHit(1);
            this.startTLHI.copyFrom(this.endTLHI);
            this.calculateCaretPos(this.endTLHI);
            this.keepCursorInView = true;
        }
        this.pty = 0.0f;
        this.ptx = 0.0f;
        this.setScrollbarValues(this.ptx, this.pty);
        this.bufferInvalid = true;
    }

    public boolean appendText(String string) {
        if (string == null || string.equals("") || this.stext.insertCharacters(string, this.stext.length(), true, false) == 0) {
            return false;
        }
        LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(this.buffer.g2);
        this.endTLHI.tli = linkedList.getLast();
        this.endTLHI.thi = this.endTLHI.tli.layout.getNextRightHit(this.endTLHI.tli.nbrChars - 1);
        this.startTLHI.copyFrom(this.endTLHI);
        this.calculateCaretPos(this.endTLHI);
        this.setScrollbarValues(this.ptx, this.pty);
        this.bufferInvalid = true;
        this.keepCursorInView = true;
        return true;
    }

    public boolean insertText(String string, int n, int n2) {
        return this.insertText(string, n, n2, false, false);
    }

    public boolean insertText(String string, int n, int n2, boolean bl, boolean bl2) {
        if (string != null && string.length() > 0) {
            int n3 = this.stext.getPos(n, n2);
            int n4 = this.stext.insertCharacters(string, n, n2, bl, bl2);
            if (n4 != 0) {
                StyledString.TextLayoutHitInfo textLayoutHitInfo = this.stext.getTLHIforCharPosition(n3 += n4);
                if (textLayoutHitInfo != null) {
                    this.endTLHI.copyFrom(textLayoutHitInfo);
                    this.moveCaretLeft(this.endTLHI);
                    this.startTLHI.copyFrom(this.endTLHI);
                    this.calculateCaretPos(textLayoutHitInfo);
                    this.keepCursorInView = true;
                    this.showCaret = true;
                }
                this.setScrollbarValues(this.ptx, this.pty);
                this.bufferInvalid = true;
                return true;
            }
        }
        return false;
    }

    public boolean insertText(String string, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        if (this.endTLHI.tli != null && this.endTLHI.thi != null) {
            n = this.endTLHI.tli.lineNo;
            n2 = this.endTLHI.thi.getCharIndex();
        }
        return this.insertText(string, n, n2, bl, bl2);
    }

    public boolean insertText(String string) {
        return this.insertText(string, false, false);
    }

    private void displayCaretPos(String string) {
        if (this.endTLHI != null && this.endTLHI.tli != null && this.endTLHI.thi != null) {
            System.out.println(string + "  :: Carat on line " + this.endTLHI.tli.lineNo + "   at char " + this.endTLHI.thi.getCharIndex());
        } else {
            System.out.println(string + "  :: unknown caret position");
        }
    }

    public String getText(int n) {
        int n2;
        Graphics2D graphics2D = this.buffer.g2;
        LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
        if (n < 0 || n >= linkedList.size()) {
            return "";
        }
        StyledString.TextLayoutInfo textLayoutInfo = linkedList.get(n);
        String string = this.stext.getPlainText(textLayoutInfo.startCharIndex, textLayoutInfo.startCharIndex + textLayoutInfo.nbrChars);
        for (n2 = string.length() - 1; n2 > 0 && string.charAt(n2) == '\n'; --n2) {
        }
        return n2 == string.length() - 1 ? string : string.substring(0, n2 + 1);
    }

    public int getTextLength(int n, boolean bl) {
        Graphics2D graphics2D = this.buffer.g2;
        LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
        if (n < 0 || n >= linkedList.size()) {
            return -1;
        }
        StyledString.TextLayoutInfo textLayoutInfo = linkedList.get(n);
        String string = this.stext.getPlainText();
        int n2 = textLayoutInfo.nbrChars;
        if (bl) {
            int n3 = textLayoutInfo.startCharIndex + textLayoutInfo.nbrChars - 1;
            while (n3 > textLayoutInfo.startCharIndex && string.charAt(n3) == '\n') {
                --n3;
                --n2;
            }
        }
        return n2;
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            boolean bl;
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            Graphics2D graphics2D = this.buffer.g2;
            graphics2D.setFont(this.localFont);
            LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
            boolean bl2 = bl = this.promptText != null && !this.hasFocus() && (linkedList.isEmpty() || this.stext.getPlainText().equals("") || this.stext.getPlainText().equals(" "));
            if (bl) {
                linkedList = this.promptText.getLines(graphics2D);
            }
            StyledString.TextLayoutHitInfo textLayoutHitInfo = null;
            StyledString.TextLayoutHitInfo textLayoutHitInfo2 = null;
            if (this.opaque) {
                this.buffer.background(this.palette[6].getRGB());
            } else {
                this.buffer.background(this.buffer.color(255, 0));
            }
            this.buffer.translate(this.tx, this.ty);
            this.buffer.noStroke();
            this.buffer.fill(this.palette[7].getRGB());
            this.buffer.rect(-1.0f, -1.0f, this.tw + 2.0f, this.th + 2.0f);
            graphics2D.setClip(this.gpTextDisplayArea);
            this.buffer.translate(-this.ptx, -this.pty);
            if (this.hasFocus() && this.stext.getPlainText().equals(" ")) {
                linkedList = this.stext.getLines(this.buffer.g2);
                this.startTLHI = new StyledString.TextLayoutHitInfo(linkedList.getFirst(), null);
                this.startTLHI.thi = this.startTLHI.tli.layout.getNextLeftHit(1);
                this.endTLHI = new StyledString.TextLayoutHitInfo(linkedList.getLast(), null);
                int n = this.endTLHI.tli.layout.getCharacterCount();
                this.endTLHI.thi = this.startTLHI.tli.layout.getNextRightHit(n - 1);
            }
            if (this.hasSelection()) {
                if (this.endTLHI.compareTo(this.startTLHI) == -1) {
                    textLayoutHitInfo = this.endTLHI;
                    textLayoutHitInfo2 = this.startTLHI;
                } else {
                    textLayoutHitInfo = this.startTLHI;
                    textLayoutHitInfo2 = this.endTLHI;
                }
            }
            for (StyledString.TextLayoutInfo textLayoutInfo : linkedList) {
                TextLayout textLayout = textLayoutInfo.layout;
                this.buffer.translate(0.0f, textLayout.getAscent());
                if (!bl && this.hasSelection() && textLayoutInfo.compareTo(textLayoutHitInfo.tli) >= 0 && textLayoutInfo.compareTo(textLayoutHitInfo2.tli) <= 0) {
                    int n = 0;
                    n = textLayoutInfo.compareTo(textLayoutHitInfo.tli) == 0 ? textLayoutHitInfo.thi.getInsertionIndex() : 0;
                    int n2 = textLayoutHitInfo2.thi.getInsertionIndex();
                    n2 = textLayoutInfo.compareTo(textLayoutHitInfo2.tli) == 0 ? textLayoutHitInfo2.thi.getInsertionIndex() : textLayoutInfo.nbrChars - 1;
                    graphics2D.setColor(this.palette[14]);
                    Shape shape = textLayout.getLogicalHighlightShape(n, n2);
                    graphics2D.fill(shape);
                }
                graphics2D.setColor(this.palette[2]);
                textLayoutInfo.layout.draw(graphics2D, 0.0f, 0.0f);
                this.buffer.translate(0.0f, textLayout.getDescent() + textLayout.getLeading());
            }
            graphics2D.setClip(null);
            this.buffer.endDraw();
        }
    }

    @Override
    public void pre() {
        if (this.keepCursorInView) {
            boolean bl = false;
            boolean bl2 = false;
            float f = this.caretX - this.tw + 2.0f;
            float f2 = this.caretY - this.th + 2.0f * this.stext.getMaxLineHeight();
            if (this.endTLHI != null) {
                if (this.ptx > this.caretX) {
                    this.ptx -= this.getScrollAmount();
                    if (this.ptx < 0.0f) {
                        this.ptx = 0.0f;
                    }
                    bl = true;
                } else if (this.ptx < f) {
                    this.ptx += this.getScrollAmount();
                    if (this.ptx > f) {
                        this.ptx = f;
                    }
                    bl = true;
                }
                if (this.pty > this.caretY) {
                    this.pty -= this.getScrollAmount();
                    if (this.pty < 0.0f) {
                        this.pty = 0.0f;
                    }
                    bl2 = true;
                } else if (this.pty < f2) {
                    this.pty += this.getScrollAmount();
                    if (this.pty > f2) {
                        this.pty = f2;
                    }
                    bl2 = true;
                }
                if (bl && this.hsb != null) {
                    this.hsb.setValue(this.ptx / (this.stext.getMaxLineLength() + 4.0f));
                }
                if (bl2 && this.vsb != null) {
                    this.vsb.setValue(this.pty / (this.stext.getTextAreaHeight() + 1.5f * this.stext.getMaxLineHeight()));
                }
            }
            if (bl || bl2) {
                this.bufferInvalid = true;
            } else {
                this.keepCursorInView = false;
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.pushMatrix();
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        if (focusIsWith == this && this.showCaret && this.endTLHI != null) {
            Object object = this.endTLHI.tli.layout.getCaretInfo(this.endTLHI.thi);
            float f = -this.ptx + object[0];
            float f2 = -this.pty + this.endTLHI.tli.yPosInPara;
            float f3 = f2 - object[3] + object[5];
            if (f >= 0.0f && f <= this.tw && f2 >= 0.0f && f3 <= this.th) {
                this.winApp.strokeWeight(1.5f);
                this.winApp.stroke(this.palette[12].getRGB());
                this.winApp.line(this.tx + f, this.ty + Math.max(0.0f, f2), this.tx + f, this.ty + Math.min(this.th, f3));
            }
        }
        this.winApp.popMatrix();
        if (this.children != null) {
            for (GAbstractControl gAbstractControl : this.children) {
                gAbstractControl.draw();
            }
        }
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    public PGraphics getSnapshot() {
        this.updateBuffer();
        PGraphics pGraphics = this.winApp.createGraphics(this.buffer.width, this.buffer.height, "processing.awt.PGraphicsJava2D");
        pGraphics.beginDraw();
        pGraphics.image((PImage)this.buffer, 0.0f, 0.0f);
        if (this.hsb != null) {
            pGraphics.pushMatrix();
            pGraphics.translate(this.hsb.getX(), this.hsb.getY());
            pGraphics.image((PImage)this.hsb.getBuffer(), 0.0f, 0.0f);
            pGraphics.popMatrix();
        }
        if (this.vsb != null) {
            pGraphics.pushMatrix();
            pGraphics.translate(this.width - 6.0f, 6.0f);
            pGraphics.rotate(1.5707964f);
            pGraphics.image((PImage)this.vsb.getBuffer(), 0.0f, 0.0f);
            pGraphics.popMatrix();
        }
        pGraphics.endDraw();
        return pGraphics;
    }

    @Override
    protected void keyPressedProcess(int n, char c, boolean bl, boolean bl2) {
        this.ksm.logKey(1);
        boolean bl3 = true;
        switch (n) {
            case 37: {
                this.moveCaretLeft(this.endTLHI);
                break;
            }
            case 39: {
                this.moveCaretRight(this.endTLHI);
                break;
            }
            case 38: {
                this.moveCaretUp(this.endTLHI);
                break;
            }
            case 40: {
                this.moveCaretDown(this.endTLHI);
                break;
            }
            case 36: {
                if (bl2) {
                    this.moveCaretStartOfText(this.endTLHI);
                    break;
                }
                this.moveCaretStartOfLine(this.endTLHI);
                break;
            }
            case 35: {
                if (bl2) {
                    this.moveCaretEndOfText(this.endTLHI);
                    break;
                }
                this.moveCaretEndOfLine(this.endTLHI);
                break;
            }
            case 65: {
                if (bl2) {
                    this.moveCaretStartOfText(this.startTLHI);
                    this.moveCaretEndOfText(this.endTLHI);
                    bl = true;
                    break;
                }
                bl3 = false;
                break;
            }
            case 67: {
                if (bl2) {
                    GClip.copy(this.getSelectedText());
                }
                bl3 = false;
                break;
            }
            case 86: {
                if (bl2) {
                    String string = GClip.paste();
                    if (string.length() <= 0) break;
                    this.ksm.logKey(string.length());
                    if (this.hasSelection()) {
                        this.stext.deleteCharacters(this.pos, this.nbr);
                    }
                    this.stext.insertCharacters(string, this.pos);
                    this.adjust = string.length();
                    this.textChanged = true;
                    break;
                }
                bl3 = false;
                break;
            }
            default: {
                bl3 = false;
            }
        }
        if (bl3) {
            this.calculateCaretPos(this.endTLHI);
            if (this.caretX > (float)this.stext.getWrapWidth()) {
                switch (n) {
                    case 35: 
                    case 37: 
                    case 38: 
                    case 40: {
                        this.moveCaretLeft(this.endTLHI);
                        bl3 = true;
                        break;
                    }
                    case 39: {
                        if (!this.moveCaretRight(this.endTLHI)) {
                            this.moveCaretLeft(this.endTLHI);
                        }
                        bl3 = true;
                    }
                }
                this.calculateCaretPos(this.endTLHI);
            }
            this.calculateCaretPos(this.endTLHI);
            if (!bl) {
                this.startTLHI.copyFrom(this.endTLHI);
            }
            this.bufferInvalid = true;
        }
    }

    @Override
    protected void keyTypedProcess(int n, char c, boolean bl, boolean bl2) {
        this.ksm.logKey(1);
        char c2 = c;
        this.newline = false;
        this.backspace = false;
        if (this.isDisplayable(c2)) {
            if (this.hasSelection()) {
                this.stext.deleteCharacters(this.pos, this.nbr);
            }
            this.stext.insertCharacters("" + c, this.pos);
            this.adjust = 1;
            this.textChanged = true;
        } else if (c == '\b') {
            if (this.hasSelection()) {
                this.stext.deleteCharacters(this.pos, this.nbr);
                this.adjust = 0;
                this.textChanged = true;
            } else if (this.stext.deleteCharacters(this.pos - 1, 1)) {
                this.adjust = -1;
                this.textChanged = true;
                this.backspace = true;
            }
        } else if (c == '\u007f') {
            if (this.hasSelection()) {
                this.stext.deleteCharacters(this.pos, this.nbr);
                this.adjust = 0;
                this.textChanged = true;
            } else if (this.stext.deleteCharacters(this.pos, 1)) {
                this.adjust = 0;
                this.textChanged = true;
            }
        } else if (c == '\n' || c == '\r') {
            this.fireEvent(new Object[]{this, GEvent.ENTERED});
            if (this.stext.insertEOL(this.pos)) {
                this.adjust = 1;
                this.textChanged = true;
                this.newline = true;
            }
        } else if (c == '\t' && this.tabManager != null) {
            boolean bl3;
            boolean bl4 = bl3 = bl ? this.tabManager.prevControl(this) : this.tabManager.nextControl(this);
            if (bl3) {
                this.startTLHI.copyFrom(this.endTLHI);
                return;
            }
        }
        if (this.stext.length() == 0) {
            this.stext.insertCharacters(" ", 0);
            ++this.adjust;
            this.textChanged = true;
        }
    }

    @Override
    protected boolean changeText() {
        if (!super.changeText()) {
            return false;
        }
        if (this.newline) {
            if (this.pos >= this.stext.length()) {
                this.stext.insertCharacters(" ", this.pos);
                this.stext.getLines(this.buffer.g2);
            }
            this.moveCaretRight(this.endTLHI);
            this.calculateCaretPos(this.endTLHI);
        }
        if (this.backspace && this.pos > 0) {
            char c = this.stext.getPlainText().charAt(this.pos - 1);
            if (c == '\n') {
                this.moveCaretRight(this.endTLHI);
                this.calculateCaretPos(this.endTLHI);
            }
            if (this.pos >= this.stext.length()) {
                this.stext.insertCharacters(" ", this.pos);
                this.stext.getLines(this.buffer.g2);
            }
        }
        this.startTLHI.copyFrom(this.endTLHI);
        return true;
    }

    @Override
    protected boolean moveCaretStartOfLine(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.thi.getCharIndex() == 0) {
            return false;
        }
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextLeftHit(1);
        return true;
    }

    @Override
    protected boolean moveCaretEndOfLine(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.thi.getCharIndex() == textLayoutHitInfo.tli.nbrChars - 1) {
            return false;
        }
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.tli.nbrChars - 1);
        return true;
    }

    protected boolean moveCaretStartOfText(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.tli.lineNo == 0 && textLayoutHitInfo.thi.getCharIndex() == 0) {
            return false;
        }
        textLayoutHitInfo.tli = this.stext.getTLIforLineNo(0);
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextLeftHit(1);
        return true;
    }

    protected boolean moveCaretEndOfText(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.tli.lineNo == this.stext.getNbrLines() - 1 && textLayoutHitInfo.thi.getCharIndex() == textLayoutHitInfo.tli.nbrChars - 1) {
            return false;
        }
        textLayoutHitInfo.tli = this.stext.getTLIforLineNo(this.stext.getNbrLines() - 1);
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.tli.nbrChars - 1);
        return true;
    }

    protected boolean moveCaretUp(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.tli.lineNo == 0) {
            return false;
        }
        StyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforLineNo(textLayoutHitInfo.tli.lineNo - 1);
        TextHitInfo textHitInfo = textLayoutInfo.layout.hitTestChar(this.caretX, 0.0f);
        textLayoutHitInfo.tli = textLayoutInfo;
        textLayoutHitInfo.thi = textHitInfo;
        return true;
    }

    protected boolean moveCaretDown(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.tli.lineNo == this.stext.getNbrLines() - 1) {
            return false;
        }
        StyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforLineNo(textLayoutHitInfo.tli.lineNo + 1);
        TextHitInfo textHitInfo = textLayoutInfo.layout.hitTestChar(this.caretX, 0.0f);
        textLayoutHitInfo.tli = textLayoutInfo;
        textLayoutHitInfo.thi = textHitInfo;
        return true;
    }

    @Override
    protected boolean moveCaretLeft(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        TextHitInfo textHitInfo = textLayoutHitInfo.tli.layout.getNextLeftHit(textLayoutHitInfo.thi);
        if (textHitInfo == null) {
            if (textLayoutHitInfo.tli.lineNo == 0) {
                return false;
            }
            StyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforLineNo(textLayoutHitInfo.tli.lineNo - 1);
            textHitInfo = textLayoutInfo.layout.getNextRightHit(textLayoutInfo.nbrChars - 1);
            textLayoutHitInfo.tli = textLayoutInfo;
            textLayoutHitInfo.thi = textHitInfo;
        } else {
            textLayoutHitInfo.thi = textHitInfo;
        }
        return true;
    }

    @Override
    protected boolean moveCaretRight(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        TextHitInfo textHitInfo = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.thi);
        if (textHitInfo == null) {
            if (textLayoutHitInfo.tli.lineNo >= this.stext.getNbrLines() - 1) {
                return false;
            }
            StyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforLineNo(textLayoutHitInfo.tli.lineNo + 1);
            textHitInfo = textLayoutInfo.layout.getNextLeftHit(1);
            textLayoutHitInfo.tli = textLayoutInfo;
            textLayoutHitInfo.thi = textHitInfo;
        } else {
            textLayoutHitInfo.thi = textHitInfo;
        }
        return true;
    }

    public void moveCaretTo(int n, int n2) {
        try {
            StyledString.TextLayoutHitInfo textLayoutHitInfo = this.stext.getTLHIforCharPosition(n, n2);
            if (textLayoutHitInfo != null) {
                this.startTLHI.copyFrom(textLayoutHitInfo);
                this.endTLHI.copyFrom(textLayoutHitInfo);
                this.calculateCaretPos(textLayoutHitInfo);
                this.keepCursorInView = true;
                this.showCaret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int[] getCaretPos() {
        return this.getCaretPos(null);
    }

    public int[] getCaretPos(int[] nArray) {
        if (nArray == null || nArray.length != 2) {
            nArray = new int[2];
        }
        if (this.endTLHI == null || this.endTLHI.tli == null || this.endTLHI.thi == null) {
            nArray[1] = -1;
            nArray[0] = -1;
        } else {
            nArray[0] = this.endTLHI.tli.lineNo;
            nArray[1] = this.endTLHI.thi.getCharIndex();
        }
        return nArray;
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.ox -= this.tx;
        this.oy -= this.ty;
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot == 1 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (this.currSpot == 1) {
                    if (focusIsWith != this && this.z >= GTextArea.focusObjectZ()) {
                        this.keepCursorInView = true;
                        this.takeFocus();
                    }
                    this.dragging = false;
                    if (this.stext.getPlainText().equals("")) {
                        this.stext.setText(" ", this.stext.getWrapWidth());
                    }
                    if (this.stext.getPlainText().equals(" ")) {
                        LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(this.buffer.g2);
                        this.startTLHI = new StyledString.TextLayoutHitInfo(linkedList.getFirst(), null);
                        this.startTLHI.thi = this.startTLHI.tli.layout.getNextLeftHit(1);
                        this.endTLHI = new StyledString.TextLayoutHitInfo(linkedList.getLast(), null);
                        int n = this.endTLHI.tli.layout.getCharacterCount();
                        this.endTLHI.thi = this.startTLHI.tli.layout.getNextRightHit(n - 1);
                    } else {
                        this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                        this.startTLHI = new StyledString.TextLayoutHitInfo(this.endTLHI);
                    }
                    this.calculateCaretPos(this.endTLHI);
                    this.bufferInvalid = true;
                    break;
                }
                if (focusIsWith != this) break;
                this.loseFocus(null);
                break;
            }
            case 2: {
                this.dragging = false;
                this.bufferInvalid = true;
                break;
            }
            case 4: {
                if (focusIsWith != this) break;
                this.keepCursorInView = true;
                this.dragging = true;
                this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                this.calculateCaretPos(this.endTLHI);
                this.fireEvent(new Object[]{this, GEvent.SELECTION_CHANGED});
                this.bufferInvalid = true;
            }
        }
    }

    @Override
    protected void calculateCaretPos(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        float[] fArray = textLayoutHitInfo.tli.layout.getCaretInfo(textLayoutHitInfo.thi);
        this.caretX = fArray[0];
        this.caretY = textLayoutHitInfo.tli.yPosInPara;
    }
}

