/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.GAlign;
import g4p_controls.GAnimIcon;
import g4p_controls.GEvent;
import g4p_controls.GIcon;
import g4p_controls.GTextIconBase;
import g4p_controls.GToggleGroup;
import g4p_controls.HotSpot;
import g4p_controls.StyledString;
import java.awt.Graphics2D;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PImage;
import processing.event.MouseEvent;

public abstract class GToggleControl
extends GTextIconBase {
    protected GToggleGroup group = null;
    protected boolean selected = false;

    public GToggleControl(PApplet pApplet, float f, float f2, float f3, float f4) {
        super(pApplet, f, f2, f3, f4);
        this.opaque = false;
        this.hotspots = new HotSpot[]{new HotSpot.HSrect(1, 0.0f, 0.0f, this.width, this.height)};
    }

    @Override
    public void setIcon(GIcon gIcon, GAlign gAlign, GAlign gAlign2, GAlign gAlign3) {
        super.setIcon(gIcon, gAlign, gAlign2, gAlign3);
        if (this.icon.me() != null) {
            GAnimIcon gAnimIcon = (GAnimIcon)this.icon;
            if (!gAnimIcon.hasClip("SELECT")) {
                gAnimIcon.storeAnim("SELECT", gAnimIcon.anim_clip.start, gAnimIcon.anim_clip.end, gAnimIcon.anim_clip.interval, 1);
            }
            if (!gAnimIcon.hasClip("DESELECT")) {
                gAnimIcon.storeAnim("DESELECT", gAnimIcon.anim_clip.end, gAnimIcon.anim_clip.start, gAnimIcon.anim_clip.interval, 1);
            }
            this.setSelected(false);
        }
        this.bufferInvalid = true;
    }

    protected void setToggleGroup(GToggleGroup gToggleGroup) {
        this.group = gToggleGroup;
    }

    public GToggleGroup getToggleGroup() {
        return this.group;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.bufferInvalid |= this.selected != bl;
        GAnimIcon gAnimIcon = this.icon.me();
        if (gAnimIcon != null) {
            if (bl) {
                gAnimIcon.animate("SELECT");
            } else {
                gAnimIcon.animate("DESELECT");
            }
        }
        if (bl && this.group != null) {
            this.group.makeSelected(this);
        }
        this.selected = bl;
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot >= 0 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (focusIsWith == this || this.currSpot < 0 || this.z <= GToggleControl.focusObjectZ()) break;
                this.dragging = false;
                this.takeFocus();
                break;
            }
            case 3: {
                if (focusIsWith != this) break;
                if (!this.selected || this.group == null) {
                    this.setSelected(!this.selected);
                    if (this.selected) {
                        this.fireEvent(new Object[]{this, GEvent.SELECTED});
                    } else if (this.group == null) {
                        this.fireEvent(new Object[]{this, GEvent.DESELECTED});
                    }
                }
                this.loseFocus(null);
                break;
            }
            case 4: {
                this.dragging = true;
                break;
            }
            case 2: {
                if (focusIsWith == this && this.dragging) {
                    this.loseFocus(null);
                }
                this.dragging = false;
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            Graphics2D graphics2D = this.buffer.g2;
            graphics2D.setFont(this.localFont);
            LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
            this.buffer.background(this.opaque ? this.palette[6].getRGB() : this.palette[2].getRGB() & 0xFFFFFF | 0x10101);
            if (this.icon.me() == null) {
                this.buffer.image(this.icon.getFrame(this.selected ? 1 : 0), this.iconX, this.iconY);
            } else {
                this.buffer.image(this.icon.getFrame(), this.iconX, this.iconY);
            }
            this.displayText(graphics2D, linkedList);
            this.buffer.endDraw();
        }
    }
}

