/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import com.jogamp.newt.event.WindowAdapter;
import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GConstants;
import g4p_controls.GConstantsInternal;
import g4p_controls.GMessenger;
import g4p_controls.GWinData;
import g4p_controls.GWindowAWT;
import g4p_controls.GWindowNEWT;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PVector;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public abstract class GWindow
extends PApplet
implements GConstants,
GConstantsInternal {
    protected int actionOnClose = 3843;
    public GWinData data;
    public String tag;
    public int tagNo;
    protected final int w;
    protected final int h;
    protected final String title;
    protected String renderer_type;
    protected boolean preparedForClosure = false;
    public LinkedList<GAbstractControl> windowControls = new LinkedList();
    public LinkedList<GAbstractControl> toRemove = new LinkedList();
    public LinkedList<GAbstractControl> toAdd = new LinkedList();
    protected Object preHandlerObject = null;
    protected Method preHandlerMethod = null;
    protected String preHandlerMethodName;
    protected Object postHandlerObject = null;
    protected Method postHandlerMethod = null;
    protected String postHandlerMethodName;
    protected Object drawHandlerObject = null;
    protected Method drawHandlerMethod = null;
    protected String drawHandlerMethodName;
    protected Object keyHandlerObject = null;
    protected Method keyHandlerMethod = null;
    protected String keyHandlerMethodName;
    protected Object mouseHandlerObject = null;
    protected Method mouseHandlerMethod = null;
    protected String mouseHandlerMethodName;
    protected Object closeHandlerObject = null;
    protected Method closetHandlerMethod = null;
    protected String closeHandlerMethodName;
    protected boolean is3D;

    public static GWindow getWindow(PApplet pApplet, String string, int n, int n2, int n3, int n4, String string2) {
        G4P.registerSketch(pApplet);
        GWindow gWindow = null;
        if (string2.equals("processing.awt.PGraphicsJava2D")) {
            gWindow = new GWindowAWT(string, n3, n4);
        } else if (string2.equals("processing.opengl.PGraphics2D")) {
            gWindow = new GWindowNEWT(string, n3, n4, false);
        } else if (string2.equals("processing.opengl.PGraphics3D")) {
            gWindow = new GWindowNEWT(string, n3, n4, true);
        }
        if (gWindow != null) {
            String string3 = "--sketch-path=" + G4P.sketchWindow.sketchPath();
            String string4 = "--location=" + n + "," + n2;
            String string5 = gWindow.getClass().getName();
            String[] stringArray = new String[]{string3, string4, string5};
            G4P.registerWindow(gWindow);
            PApplet.runSketch((String[])stringArray, (PApplet)gWindow);
        }
        return gWindow;
    }

    protected GWindow(String string, int n, int n2) {
        this.title = string;
        this.w = n;
        this.h = n2;
        this.registerMethods();
    }

    protected void registerMethods() {
        this.registerMethod("pre", this);
        this.registerMethod("draw", this);
        this.registerMethod("post", this);
        this.registerMethod("mouseEvent", this);
        this.registerMethod("keyEvent", this);
    }

    protected void unregisterMethods() {
        this.unregisterMethod("pre", this);
        this.unregisterMethod("draw", this);
        this.unregisterMethod("post", this);
        this.unregisterMethod("mouseEvent", this);
        this.unregisterMethod("keyEvent", this);
        this.preHandlerObject = null;
        this.drawHandlerObject = null;
        this.postHandlerObject = null;
        this.mouseHandlerObject = null;
        this.keyHandlerObject = null;
    }

    public void addData(GWinData gWinData) {
        this.data = gWinData;
    }

    protected void addToWindow(GAbstractControl gAbstractControl) {
        if (!this.toAdd.contains(gAbstractControl) && !this.windowControls.contains(gAbstractControl)) {
            this.toAdd.add(gAbstractControl);
        }
    }

    protected void removeFromWindow(GAbstractControl gAbstractControl) {
        this.toRemove.add(gAbstractControl);
    }

    void invalidateBuffers() {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            gAbstractControl.bufferInvalid = true;
        }
    }

    void setColorScheme(int n) {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            gAbstractControl.setLocalColorScheme(n);
        }
    }

    void setAlpha(int n) {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            gAbstractControl.setAlpha(n);
        }
    }

    public void setVisible(boolean bl) {
        this.surface.setVisible(bl);
    }

    public abstract boolean isVisible();

    public void setTitle(String string) {
        this.surface.setTitle(string);
    }

    public abstract String getTitle();

    public void setLocation(int n, int n2) {
        this.surface.setLocation(n, n2);
    }

    public abstract PVector getPosition(PVector var1);

    public void setAlwaysOnTop(boolean bl) {
        this.surface.setAlwaysOnTop(bl);
    }

    public void draw() {
        this.pushMatrix();
        if (this.drawHandlerObject != null) {
            try {
                this.drawHandlerMethod.invoke(this.drawHandlerObject, this, this.data);
            }
            catch (Exception exception) {
                GMessenger.message(-16777211, new Object[]{this.drawHandlerObject, this.drawHandlerMethodName, exception});
            }
        }
        this.popMatrix();
    }

    public void pre() {
        if (this.preHandlerObject != null) {
            try {
                this.preHandlerMethod.invoke(this.preHandlerObject, this, this.data);
            }
            catch (Exception exception) {
                GMessenger.message(-16777211, new Object[]{this.preHandlerObject, this.preHandlerMethodName, exception});
            }
        }
        if (GAbstractControl.controlToTakeFocus != null && GAbstractControl.controlToTakeFocus.getPApplet() == this) {
            GAbstractControl.controlToTakeFocus.setFocus(true);
            GAbstractControl.controlToTakeFocus = null;
        }
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 4) != 4) continue;
            gAbstractControl.pre();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post() {
        if (this.postHandlerObject != null) {
            try {
                this.postHandlerMethod.invoke(this.postHandlerObject, this, this.data);
            }
            catch (Exception exception) {
                GMessenger.message(-16777211, new Object[]{this.postHandlerObject, this.postHandlerMethodName, exception});
            }
        }
        if (G4P.cursorChangeEnabled) {
            if (GAbstractControl.cursorIsOver != null && GAbstractControl.cursorIsOver.getPApplet() == this) {
                this.cursor(GAbstractControl.cursorIsOver.cursorOver);
            } else {
                this.cursor(G4P.mouseOff);
            }
        }
        for (GAbstractControl iterator : this.windowControls) {
            if ((iterator.registeredMethods & 0x10) != 16) continue;
            iterator.post();
        }
        GWindow gWindow = this;
        synchronized (gWindow) {
            if (!this.toRemove.isEmpty()) {
                for (GAbstractControl gAbstractControl : this.toRemove) {
                    if (GAbstractControl.focusIsWith == gAbstractControl) {
                        gAbstractControl.loseFocus(null);
                    }
                    gAbstractControl.buffer = null;
                    if (gAbstractControl.parent != null) {
                        gAbstractControl.parent.children.remove(gAbstractControl);
                        gAbstractControl.parent = null;
                    }
                    if (gAbstractControl.children != null) {
                        gAbstractControl.children.clear();
                    }
                    gAbstractControl.palette = null;
                    gAbstractControl.eventHandlerObject = null;
                    gAbstractControl.eventHandlerMethod = null;
                    gAbstractControl.winApp = null;
                    this.windowControls.remove(gAbstractControl);
                    System.gc();
                }
                this.toRemove.clear();
            }
            if (!this.toAdd.isEmpty()) {
                for (GAbstractControl gAbstractControl : this.toAdd) {
                    this.windowControls.add(gAbstractControl);
                }
                this.toAdd.clear();
                Collections.sort(this.windowControls, G4P.zorder);
            }
        }
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (this.mouseHandlerObject != null) {
            try {
                this.mouseHandlerMethod.invoke(this.mouseHandlerObject, this, this.data, mouseEvent);
            }
            catch (Exception exception) {
                GMessenger.message(-16777211, new Object[]{this.mouseHandlerObject, this.mouseHandlerMethodName, exception});
            }
        }
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 2) != 2) continue;
            gAbstractControl.mouseEvent(mouseEvent);
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (this.keyHandlerObject != null) {
            try {
                this.keyHandlerMethod.invoke(this.keyHandlerObject, this, this.data, keyEvent);
            }
            catch (Exception exception) {
                GMessenger.message(-16777211, new Object[]{this.keyHandlerObject, this.keyHandlerMethodName, exception});
            }
        }
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 8) != 8) continue;
            gAbstractControl.keyEvent(keyEvent);
        }
    }

    public void addDrawHandler(Object object, String string) {
        try {
            this.drawHandlerMethod = object.getClass().getMethod(string, PApplet.class, GWinData.class);
            this.drawHandlerObject = object;
            this.drawHandlerMethodName = string;
        }
        catch (Exception exception) {
            this.drawHandlerObject = null;
            GMessenger.message(-16777214, new Object[]{this, string, new Class[]{PApplet.class, GWinData.class}});
        }
    }

    public void addPreHandler(Object object, String string) {
        try {
            this.preHandlerMethod = object.getClass().getMethod(string, PApplet.class, GWinData.class);
            this.preHandlerObject = object;
            this.preHandlerMethodName = string;
        }
        catch (Exception exception) {
            this.preHandlerMethod = null;
            GMessenger.message(-16777214, new Object[]{this, string, new Class[]{PApplet.class, GWinData.class}});
        }
    }

    public void addMouseHandler(Object object, String string) {
        try {
            this.mouseHandlerMethod = object.getClass().getMethod(string, PApplet.class, GWinData.class, MouseEvent.class);
            this.mouseHandlerObject = object;
            this.mouseHandlerMethodName = string;
        }
        catch (Exception exception) {
            this.mouseHandlerObject = null;
            GMessenger.message(-16777214, new Object[]{this, string, new Class[]{PApplet.class, GWinData.class, MouseEvent.class}});
        }
    }

    public void addKeyHandler(Object object, String string) {
        try {
            this.keyHandlerMethod = object.getClass().getMethod(string, PApplet.class, GWinData.class, KeyEvent.class);
            this.keyHandlerObject = object;
            this.keyHandlerMethodName = string;
        }
        catch (Exception exception) {
            this.keyHandlerObject = null;
            GMessenger.message(-16777214, new Object[]{this, string, new Class[]{PApplet.class, GWinData.class, KeyEvent.class}});
        }
    }

    public void addPostHandler(Object object, String string) {
        try {
            this.postHandlerMethod = object.getClass().getMethod(string, PApplet.class, GWinData.class);
            this.postHandlerObject = object;
            this.postHandlerMethodName = string;
        }
        catch (Exception exception) {
            this.postHandlerObject = null;
            GMessenger.message(-16777214, new Object[]{this, string, new Class[]{PApplet.class, GWinData.class}});
        }
    }

    public void addOnCloseHandler(Object object, String string) {
        try {
            this.closeHandlerObject = object;
            this.closeHandlerMethodName = string;
            this.closetHandlerMethod = object.getClass().getMethod(string, GWindow.class);
        }
        catch (Exception exception) {
            GMessenger.message(-16777214, new Object[]{this, string, new Class[]{GWindow.class}});
            this.closeHandlerObject = null;
            this.closeHandlerMethodName = "";
        }
    }

    public void close() {
        if (this.actionOnClose == 3843 || this.actionOnClose == 3841) {
            return;
        }
        this.prepareWindowForClosure();
    }

    public void forceClose() {
        if (this.actionOnClose == 3841) {
            return;
        }
        if (this.actionOnClose == 3843) {
            this.setActionOnClose(3842);
        }
        this.prepareWindowForClosure();
    }

    protected abstract void fireCloseWindowEvent();

    protected void prepareWindowForClosure() {
        this.noLoop();
        this.unregisterMethods();
        G4P.deregisterWindow(this);
        new Thread(new GCloseNotifier(this)).start();
    }

    public abstract void setActionOnClose(int var1);

    public void settings() {
        this.size(this.w, this.h, this.renderer_type);
    }

    protected abstract void initListeners();

    public void setup() {
        this.surface.setTitle(this.title);
        this.initListeners();
    }

    public void performCloseAction() {
        if (this.closeHandlerObject != null) {
            try {
                this.closetHandlerMethod.invoke(this.closeHandlerObject, this);
            }
            catch (Exception exception) {
                GMessenger.message(-16777211, new Object[]{this.closeHandlerObject, this.closeHandlerMethodName, exception});
            }
        }
    }

    protected class WindowAdapterNEWT
    extends WindowAdapter {
        GWindow window = null;

        public WindowAdapterNEWT(GWindow gWindow2) {
            this.window = gWindow2;
        }

        public void windowGainedFocus(com.jogamp.newt.event.WindowEvent windowEvent) {
            GWindow.this.focused = true;
            GWindow.this.focusGained();
        }

        public void windowLostFocus(com.jogamp.newt.event.WindowEvent windowEvent) {
            GWindow.this.focused = false;
            GWindow.this.focusLost();
        }

        public void windowDestroyNotify(com.jogamp.newt.event.WindowEvent windowEvent) {
            switch (GWindow.this.actionOnClose) {
                case 3841: {
                    GWindow.this.exit();
                    break;
                }
                case 3842: {
                    GWindow.this.performCloseAction();
                    G4P.deregisterWindow(this.window);
                    GWindow.this.dispose();
                }
            }
        }
    }

    protected class WindowAdapterAWT
    extends java.awt.event.WindowAdapter {
        GWindow window = null;

        public WindowAdapterAWT(GWindow gWindow2) {
            this.window = gWindow2;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            switch (GWindow.this.actionOnClose) {
                case 3841: {
                    System.exit(0);
                    break;
                }
                case 3842: {
                    GWindow.this.performCloseAction();
                    G4P.deregisterWindow(this.window);
                    GWindow.this.dispose();
                }
            }
        }
    }

    protected class GCloseNotifier
    implements Runnable {
        GWindow window = null;

        public GCloseNotifier(GWindow gWindow2) {
            this.window = gWindow2;
        }

        @Override
        public void run() {
            if (this.window != null) {
                this.window.fireCloseWindowEvent();
            }
        }
    }
}

