/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GConstants;
import g4p_controls.GConstantsInternal;
import java.util.Collections;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PMatrix;
import processing.core.PMatrix3D;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public class GWindowImpl
implements GConstants,
GConstantsInternal {
    public LinkedList<GAbstractControl> windowControls = new LinkedList();
    public LinkedList<GAbstractControl> toRemove = new LinkedList();
    public LinkedList<GAbstractControl> toAdd = new LinkedList();
    PApplet app;
    PMatrix orgMatrix = null;

    public GWindowImpl(PApplet pApplet) {
        this.app = pApplet;
        PMatrix pMatrix = pApplet.getMatrix();
        if (pMatrix instanceof PMatrix3D) {
            this.orgMatrix = pMatrix;
        }
        this.registerMethods();
    }

    protected void registerMethods() {
        this.app.registerMethod("pre", (Object)this);
        this.app.registerMethod("draw", (Object)this);
        this.app.registerMethod("post", (Object)this);
        this.app.registerMethod("mouseEvent", (Object)this);
        this.app.registerMethod("keyEvent", (Object)this);
    }

    protected void unregisterMethods() {
        this.app.unregisterMethod("pre", (Object)this);
        this.app.unregisterMethod("draw", (Object)this);
        this.app.unregisterMethod("post", (Object)this);
        this.app.unregisterMethod("mouseEvent", (Object)this);
        this.app.unregisterMethod("keyEvent", (Object)this);
    }

    protected void addToWindow(GAbstractControl gAbstractControl) {
        if (!this.toAdd.contains(gAbstractControl) && !this.windowControls.contains(gAbstractControl)) {
            this.toAdd.add(gAbstractControl);
        }
    }

    protected void removeFromWindow(GAbstractControl gAbstractControl) {
        this.toRemove.add(gAbstractControl);
    }

    void invalidateBuffers() {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            gAbstractControl.bufferInvalid = true;
        }
    }

    void setColorScheme(int n) {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            gAbstractControl.setLocalColorScheme(n);
        }
    }

    void setAlpha(int n) {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            gAbstractControl.setAlpha(n);
        }
    }

    public void draw() {
        this.app.pushMatrix();
        if (this.orgMatrix != null) {
            this.app.setMatrix(this.orgMatrix);
        }
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 1) != 1) continue;
            gAbstractControl.draw();
        }
        this.app.popMatrix();
    }

    String actionString(MouseEvent mouseEvent) {
        switch (mouseEvent.getAction()) {
            default: {
                return "UNKNOWN";
            }
            case 3: {
                return "CLICK";
            }
            case 4: {
                return "DRAG";
            }
            case 6: {
                return "ENTER";
            }
            case 7: {
                return "EXIT";
            }
            case 5: {
                return "MOVE";
            }
            case 1: {
                return "PRESS";
            }
            case 2: {
                return "RELEASE";
            }
            case 8: 
        }
        return "WHEEL";
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 2) != 2) continue;
            gAbstractControl.mouseEvent(mouseEvent);
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 8) != 8) continue;
            gAbstractControl.keyEvent(keyEvent);
        }
    }

    public void pre() {
        if (GAbstractControl.controlToTakeFocus != null && GAbstractControl.controlToTakeFocus.getPApplet() == this.app) {
            GAbstractControl.controlToTakeFocus.setFocus(true);
            GAbstractControl.controlToTakeFocus = null;
        }
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 4) != 4) continue;
            gAbstractControl.pre();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post() {
        if (G4P.cursorChangeEnabled) {
            if (GAbstractControl.cursorIsOver != null && GAbstractControl.cursorIsOver.getPApplet() == this.app) {
                this.app.cursor(GAbstractControl.cursorIsOver.cursorOver);
            } else {
                this.app.cursor(G4P.mouseOff);
            }
        }
        for (GAbstractControl iterator : this.windowControls) {
            if ((iterator.registeredMethods & 0x10) != 16) continue;
            iterator.post();
        }
        GWindowImpl gWindowImpl = this;
        synchronized (gWindowImpl) {
            if (!this.toRemove.isEmpty()) {
                for (GAbstractControl gAbstractControl : this.toRemove) {
                    if (GAbstractControl.focusIsWith == gAbstractControl) {
                        gAbstractControl.loseFocus(null);
                    }
                    gAbstractControl.buffer = null;
                    if (gAbstractControl.parent != null) {
                        gAbstractControl.parent.children.remove(gAbstractControl);
                        gAbstractControl.parent = null;
                    }
                    if (gAbstractControl.children != null) {
                        gAbstractControl.children.clear();
                    }
                    gAbstractControl.palette = null;
                    gAbstractControl.eventHandlerObject = null;
                    gAbstractControl.eventHandlerMethod = null;
                    gAbstractControl.winApp = null;
                    this.windowControls.remove(gAbstractControl);
                }
                this.toRemove.clear();
                System.gc();
            }
            if (!this.toAdd.isEmpty()) {
                for (GAbstractControl gAbstractControl : this.toAdd) {
                    this.windowControls.add(gAbstractControl);
                }
                this.toAdd.clear();
                Collections.sort(this.windowControls, G4P.zorder);
            }
        }
    }
}

