/*
 * Decompiled with CFR 0.152.
 */
import drop.DropEvent;
import drop.SDrop;
import g4p_controls.GEvent;
import g4p_controls.GImageButton;
import java.io.File;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PShape;
import processing.event.MouseEvent;

public class JEViewer
extends PApplet {
    final int stateWaitForLoad = 0;
    final int stateNormal = 1;
    final int stateError = 2;
    int state = 0;
    String loadPath = "";
    String loadedFile = "";
    PGraphics maps;
    PGraphics comments;
    PGraphics help;
    boolean helpWin;
    PFont ifont;
    PFont rfont;
    String myText = "DELETE or BACKSPACE and type some notes here or press F2 and load some prepared notes.";
    String cursor = "_";
    boolean blink = true;
    boolean overLogo = false;
    boolean fullwindow = false;
    PShape network;
    PImage logo;
    PImage jeslogo;
    PImage gradient;
    int fs = 18;
    float xd = 50.0f;
    float yd = 50.0f;
    GImageButton btnSVG;
    GImageButton btnTXT;
    GImageButton btnZoomIn;
    GImageButton btnZoomOut;
    GImageButton btnTextB;
    GImageButton btnTextS;
    GImageButton btnHelp;
    GImageButton btnSnapshot;
    GImageButton btnWJEO;
    GImageButton btnCloud;
    GImageButton btnLampUR;
    GImageButton btnLampLR;
    GImageButton btnLampLL;
    GImageButton btnLampUL;
    GImageButton btnLampOFF;
    GImageButton btnReset;
    SDrop drop;
    int r = 66;
    int g = 134;
    int b = 244;
    PImage splash;
    PImage splash1;
    float scaleFactor = 1.0f;
    float translateX = 0.0f;
    float translateY = 0.0f;
    int fc;

    public void setup() {
        this.splash = this.loadImage("je-splash-sm.png");
        this.splash1 = this.loadImage("je-splash.png");
        this.gradient = this.loadImage("backgroundblack.png");
        this.surface.setResizable(true);
        this.shapeMode(3);
        this.network = this.loadShape("start.svg");
        this.translateX = this.width / 2;
        this.translateY = this.height / 2;
        this.noStroke();
        PImage titlebaricon = this.loadImage("favicon-32x32.png");
        this.surface.setIcon(titlebaricon);
        this.surface.setTitle("JEViewer 1.0 and Visual Jonathan Edwards \u00a9 2017-2018 Rob Boss");
        this.logo = this.loadImage("jecgslogo.png");
        this.jeslogo = this.loadImage("jeslogo.png");
        this.ifont = this.createFont("SourceSansPro-Italic.ttf", this.fs);
        this.rfont = this.createFont("SourceSansPro-Regular.ttf", this.fs);
        this.maps = this.createGraphics(this.width, this.height);
        this.comments = this.createGraphics(this.width, this.height);
        this.textAlign(37);
        this.textSize(30.0f);
        this.fill(0);
        this.mouseX = 75;
        this.mouseY = 75;
        String[] files = new String[]{"SVG-0.png", "SVG-1.png", "SVG-1.png"};
        this.btnSVG = new GImageButton((PApplet)this, 10.0f, 10.0f, files);
        files = new String[]{"TXT-0.png", "TXT-1.png", "TXT-1.png"};
        this.btnTXT = new GImageButton((PApplet)this, 44.0f, 10.0f, files);
        files = new String[]{"WJEO-0.png", "WJEO-1.png", "WJEO-1.png"};
        this.btnWJEO = new GImageButton((PApplet)this, 78.0f, 10.0f, files);
        files = new String[]{"ZoomIn-0.png", "ZoomIn-1.png", "ZoomIn-1.png"};
        this.btnZoomIn = new GImageButton((PApplet)this, 112.0f, 10.0f, files);
        files = new String[]{"ZoomOut-0.png", "ZoomOut-1.png", "ZoomOut-1.png"};
        this.btnZoomOut = new GImageButton((PApplet)this, 146.0f, 10.0f, files);
        files = new String[]{"Reset-0.png", "Reset-1.png", "Reset-1.png"};
        this.btnReset = new GImageButton((PApplet)this, 180.0f, 10.0f, files);
        files = new String[]{"TextB-0.png", "TextB-1.png", "TextB-1.png"};
        this.btnTextB = new GImageButton((PApplet)this, 214.0f, 10.0f, files);
        files = new String[]{"TextS-0.png", "TextS-1.png", "TextS-1.png"};
        this.btnTextS = new GImageButton((PApplet)this, 248.0f, 10.0f, files);
        files = new String[]{"LampUR-0.png", "LampUR-1.png", "LampUR-1.png"};
        this.btnLampUR = new GImageButton((PApplet)this, 282.0f, 10.0f, files);
        files = new String[]{"LampLR-0.png", "LampLR-1.png", "LampLR-1.png"};
        this.btnLampLR = new GImageButton((PApplet)this, 316.0f, 10.0f, files);
        files = new String[]{"LampLL-0.png", "LampLL-1.png", "LampLL-1.png"};
        this.btnLampLL = new GImageButton((PApplet)this, 350.0f, 10.0f, files);
        files = new String[]{"LampUL-0.png", "LampUL-1.png", "LampUL-1.png"};
        this.btnLampUL = new GImageButton((PApplet)this, 384.0f, 10.0f, files);
        files = new String[]{"LampOFF-0.png", "LampOFF-1.png", "LampOFF-1.png"};
        this.btnLampOFF = new GImageButton((PApplet)this, 418.0f, 10.0f, files);
        files = new String[]{"Help-0.png", "Help-1.png", "Help-1.png"};
        this.btnHelp = new GImageButton((PApplet)this, 452.0f, 10.0f, files);
        files = new String[]{"Cloud-0.png", "Cloud-1.png", "Cloud-1.png"};
        this.btnCloud = new GImageButton((PApplet)this, 486.0f, 10.0f, files);
        this.drop = new SDrop((PApplet)this);
        this.fc = this.frameCount;
    }

    public void draw() {
        this.background(0);
        this.image(this.gradient, -5.0f, -5.0f, this.width + 10, this.height + 10);
        if (this.millis() < 10000) {
            this.image(this.splash, this.width / 2 - 202, this.height / 2 - 250);
            this.stroke(255);
            this.strokeWeight(0.75f);
            this.line(this.width / 2 + 190, this.height / 2 - 100, this.width / 2 + 420, this.height / 2 - 100);
            this.textFont(this.ifont, 18.0f);
            this.fill(255);
            this.text("VISUAL JONATHAN EDWARDS:", this.width / 2 + 200, this.height / 2 - 75);
            this.textFont(this.ifont, 14.0f);
            this.fill(255);
            this.text("A creative non-linear approach\nto America\u2019s theologian", this.width / 2 + 220, this.height / 2 - 50);
            this.line(this.width / 2 + 203, this.height / 2 - 14, this.width / 2 + 433, this.height / 2 - 14);
        } else {
            this.maps();
        }
        this.comments();
        this.help();
        if (this.mousePressed && this.mouseButton == 3) {
            this.xd += 10.0f;
            this.yd += 10.0f;
        } else if (this.mousePressed && this.mouseButton == 39) {
            this.xd -= 10.0f;
            this.yd -= 10.0f;
        }
        if (this.keyPressed && this.keyCode == 120) {
            this.noStroke();
            this.fill(0, 215.0f);
            this.rect(0.0f, 0.0f, this.width, this.height);
            this.image(this.splash1, this.width / 2 - 269, this.height / 2 - 281);
            this.stroke(255);
            this.strokeWeight(1.0f);
            this.line(this.width / 2 + 255, this.height / 2 - 80, this.width / 2 + 580, this.height / 2 - 80);
            this.textFont(this.ifont, 24.0f);
            this.fill(255);
            this.text("VISUAL JONATHAN EDWARDS:", this.width / 2 + 275, this.height / 2 - 45);
            this.textFont(this.ifont, 20.0f);
            this.fill(255);
            this.text("A creative non-linear approach\nto America\u2019s theologian", this.width / 2 + 300, this.height / 2 - 10);
            this.line(this.width / 2 + 270, this.height / 2 + 40, this.width / 2 + 595, this.height / 2 + 40);
            this.fill(0, 0.0f);
            this.stroke(this.r, this.g, this.b);
            this.strokeWeight(4.0f);
            this.ellipse(this.mouseX, this.mouseY, this.xd, this.yd);
            this.fill(255);
            this.stroke(255);
            this.ellipse(this.mouseX, this.mouseY, 10.0f, 10.0f);
        }
        if (this.keyPressed && this.keyCode == 122) {
            this.textFont(this.ifont, 14.0f);
            this.fill(0, 127.0f);
            this.text("Frame #" + this.frameCount, 6.0f, this.height - 7);
            this.saveFrame("frames/frame-#####.png");
        } else {
            this.textFont(this.ifont, 14.0f);
            this.fill(0);
            this.text("Hold F11 to record animation frames @ " + this.width + "px x " + this.height + "px", 6.0f, this.height - 7);
        }
    }

    public void maps() {
        this.maps.beginDraw();
        this.pushMatrix();
        this.translate(this.translateX, this.translateY);
        this.scale(this.scaleFactor);
        this.shape(this.network, 0.0f, 0.0f);
        this.popMatrix();
        this.maps.endDraw();
    }

    public void comments() {
        this.comments.beginDraw();
        if (this.focused) {
            this.fill(0, 0.0f);
            int c = this.get(this.mouseX, this.mouseY);
            this.stroke(c, 255.0f);
            this.strokeWeight(5.0f);
            this.ellipse(this.mouseX, this.mouseY, this.xd + 10.0f, this.yd + 10.0f);
            this.stroke(255);
            this.strokeWeight(1.0f);
            this.ellipse(this.mouseX, this.mouseY, this.xd - 4.0f, this.yd - 4.0f);
        } else {
            this.fill(0, 0.0f);
            int c = this.get(this.mouseX, this.mouseY);
            this.stroke(c, 64.0f);
            this.strokeWeight(5.0f);
            this.ellipse(this.mouseX, this.mouseY, this.xd + 10.0f, this.yd + 10.0f);
            this.stroke(255, 64.0f);
            this.strokeWeight(1.0f);
            this.ellipse(this.mouseX, this.mouseY, this.xd - 4.0f, this.yd - 4.0f);
        }
        if (this.focused) {
            this.fill(255);
            this.stroke(255);
            this.ellipse(this.mouseX, this.mouseY, 10.0f, 10.0f);
        } else {
            this.fill(64);
            this.stroke(64);
            this.ellipse(this.mouseX, this.mouseY, 10.0f, 10.0f);
        }
        this.noStroke();
        this.fill(255);
        this.rect(0.0f, (float)this.height / 1.225f, this.width, this.height);
        this.textFont(this.ifont, this.fs);
        this.fill(0);
        if (this.frameCount % 10 == 0) {
            boolean bl = this.blink = !this.blink;
        }
        if (this.blink) {
            this.text(this.myText, 25.0f, (float)this.height / 1.225f + 25.0f, this.width - 50, this.height);
        } else {
            this.text(String.valueOf(this.myText) + this.cursor, 25.0f, (float)this.height / 1.225f + 25.0f, this.width - 50, this.height);
        }
        this.textFont(this.ifont, 18.0f);
        this.fill(0);
        this.text("JESociety.org", this.width - 106, (float)this.height / 1.225f + 18.0f);
        this.image(this.logo, this.width - 230, (float)this.height / 1.225f - 20.0f);
        this.image(this.jeslogo, this.width - 210, this.height - this.height + 5);
        this.comments.endDraw();
    }

    public void help() {
        this.textFont(this.ifont, 14.0f);
        this.fill(0);
        this.text("Toggle F12 for instructions", this.width - 155, this.height - 7);
    }

    public void keyPressed() {
        if (this.key == '\uffff') {
            if (this.keyCode == 38) {
                this.scaleFactor += 0.05f;
            } else if (this.keyCode == 40) {
                this.scaleFactor -= 0.05f;
            }
        }
        if (this.keyCode == 36) {
            this.shapeMode(3);
            this.scaleFactor = 1.0f;
            this.translateX = this.width / 2;
            this.translateY = this.height / 2;
            this.gradient = this.loadImage("backgroundblack.png");
        }
        if (this.keyCode == 8) {
            if (this.myText.length() > 0) {
                this.myText = this.myText.substring(0, this.myText.length() - 1);
            }
        } else if (this.keyCode == 127) {
            this.myText = "";
        } else if (this.keyCode != 16 && this.keyCode != 17 && this.keyCode != 18 && this.keyCode != 38 && this.keyCode != 40 && this.keyCode != 39 && this.keyCode != 37 && this.keyCode != 36 && this.keyCode != 33 && this.keyCode != 34 && this.keyCode != 112 && this.keyCode != 113 && this.keyCode != 114 && this.keyCode != 115 && this.keyCode != 116 && this.keyCode != 117 && this.keyCode != 118 && this.keyCode != 119 && this.keyCode != 120 && this.keyCode != 122 && this.keyCode != 123) {
            this.myText = String.valueOf(this.myText) + this.key;
        }
        if (this.key == '\t') {
            int day = JEViewer.day();
            int mon = JEViewer.month();
            int yr = JEViewer.year();
            int sec = JEViewer.second();
            int min = JEViewer.minute();
            int hr = JEViewer.hour();
            this.saveFrame("snapshots/snapshot-" + mon + "." + day + "." + yr + "-" + hr + "h" + min + "m" + sec + "s" + ".png");
            String words = this.myText;
            String[] list = JEViewer.split((String)words, (char)'~');
            this.saveStrings("/notes/note-" + mon + "." + day + "." + yr + "-" + hr + "h" + min + "m" + sec + "s" + ".txt", list);
        }
        if (this.keyPressed && this.keyCode == 39) {
            this.xd += 2.0f;
            this.yd += 2.0f;
        }
        if (this.keyPressed && this.keyCode == 37 && this.xd >= 30.0f && this.yd >= 30.0f) {
            this.xd -= 2.0f;
            this.yd -= 2.0f;
        }
        if (this.keyPressed && this.keyCode == 116) {
            this.gradient = this.loadImage("backgroundgradient1.png");
        }
        if (this.keyPressed && this.keyCode == 117) {
            this.gradient = this.loadImage("backgroundgradient2.png");
        }
        if (this.keyPressed && this.keyCode == 118) {
            this.gradient = this.loadImage("backgroundgradient3.png");
        }
        if (this.keyPressed && this.keyCode == 119) {
            this.gradient = this.loadImage("backgroundgradient4.png");
        }
        if (this.keyPressed && this.keyCode == 114) {
            ++this.fs;
        }
        if (this.keyPressed && this.keyCode == 115 && this.fs >= 15) {
            --this.fs;
        }
        if (this.keyPressed && this.keyCode == 113) {
            this.loadTXT();
        }
        if (this.keyPressed && this.keyCode == 112) {
            this.loadSVG();
        }
        if (this.keyCode == 123) {
            if (this.helpWin ^= true) {
                this.noLoop();
                this.stroke(255);
                this.fill(255);
                this.rect(25.0f, 47.0f, 428.0f, 530.0f);
                this.textFont(this.ifont, 14.0f);
                this.fill(0);
                this.text("WELCOME TO JEVIEWER 1.0\nYou may begin by loading a visualization and prepared notes or typing\nnotes in the notes pane. BACKSPACE, DELETE and text size are the\nonly editing options (no copy, paste, move text cursor, etc). You may also\ndrag and drop quotes from the WORKS OF JONATHAN EDWARDS ONLINE\n(WJEO) at http://edwards.yale.edu/\n\nFunctions and Keyboard Shortcuts:\n1. Press F1 to load visualizations.\n2. Press F2 to load prepared note files.\n3. Zoom/drag image with UP/DOWN arrow keys and mouse/wheel.\n4. Resize pointer ellipse with RIGHT/LEFT arrow keys or with middle and\nright mouse buttons.\n5. Activate lamp direction by pressing F5, F6, F7 and F8.\n6. Press HOME to reset image position and background.\n7. BACKSPACE or DELETE and type notes or F2 to load prepared notes.\n8. You may also drag and drop text from WJEO.\n9. Increase or Decrease text size with F3 and F4.\n10. Hide pointer by moving mouse into notes pane.\n11. Press TAB to capture snapshots and notes in application folder.\n12. Press and hold F9 for splash screen.\n13. Press and hold F11 to record animation frames to application folder.\n14. Toggle F12 for this menu.", 30.0f, 51.0f, 475.0f, 600.0f);
            } else {
                this.loop();
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.checkButtons();
        this.translateX += (float)(this.mouseX - this.pmouseX);
        this.translateY += (float)(this.mouseY - this.pmouseY);
    }

    public void mouseMoved() {
        this.checkButtons();
    }

    public void mouseWheel(MouseEvent e) {
        this.translateX -= (float)this.mouseX;
        this.translateY -= (float)this.mouseY;
        float delta = e.getCount() > 0 ? 1.05f : (e.getCount() < 0 ? 0.952381f : 1.0f);
        this.scaleFactor *= delta;
        this.translateX *= delta;
        this.translateY *= delta;
        this.translateX += (float)this.mouseX;
        this.translateY += (float)this.mouseY;
    }

    public void checkButtons() {
        this.overLogo = this.mouseX > this.width - 165 && this.mouseX < this.width && (float)this.mouseY > (float)this.height / 1.33f - 20.0f && (float)this.mouseY < (float)this.height / 1.33f + 24.0f;
    }

    public void mousePressed() {
        if (this.overLogo) {
            this.link("http://www.jesociety.org");
        }
    }

    public void screencast() {
        this.link("http://www.jesociety.org/quick-start/");
    }

    public void wjeo() {
        this.link("http://edwards.yale.edu/research/browse");
    }

    public void cloud() {
        this.link("http://www.jesociety.org/visualization-library/");
    }

    public void loadSVG() {
        this.loadPath = "";
        File start1 = new File(String.valueOf(this.sketchPath("")) + "/*.svg");
        this.selectInput("Select a file to load:", "SVGSelectedForLoad", start1);
    }

    public void SVGSelectedForLoad(File selection) {
        if (selection == null) {
            JEViewer.println((String)"Window was closed or the user hit cancel.");
            this.state = 2;
        } else {
            this.loadPath = selection.getAbsolutePath();
            this.loadedFile = selection.getAbsolutePath();
            this.network = this.loadShape(selection.getAbsolutePath());
            this.state = 1;
        }
    }

    public void loadTXT() {
        this.loadPath = "";
        File start1 = new File(String.valueOf(this.sketchPath("")) + "/*.txt");
        this.selectInput("Select a file to load:", "TXTSelectedForLoad", start1);
    }

    public void TXTSelectedForLoad(File selection) {
        if (selection == null) {
            JEViewer.println((String)"Window was closed or the user hit cancel.");
            this.state = 2;
        } else {
            this.loadPath = selection.getAbsolutePath();
            this.loadedFile = selection.getAbsolutePath();
            String[] paragraphs = this.loadStrings(selection.getAbsolutePath());
            this.myText = PApplet.join((String[])paragraphs, (char)'\n');
            this.state = 1;
        }
    }

    public void handleButtonEvents(GImageButton button, GEvent event) {
        if (button == this.btnSVG) {
            this.loadSVG();
        } else if (button == this.btnTXT) {
            this.loadTXT();
        } else if (button == this.btnLampUR) {
            this.gradient = this.loadImage("backgroundgradient1.png");
        } else if (button == this.btnLampLR) {
            this.gradient = this.loadImage("backgroundgradient2.png");
        } else if (button == this.btnLampLL) {
            this.gradient = this.loadImage("backgroundgradient3.png");
        } else if (button == this.btnLampUL) {
            this.gradient = this.loadImage("backgroundgradient4.png");
        } else if (button == this.btnLampOFF) {
            this.gradient = this.loadImage("backgroundblack.png");
        } else if (button == this.btnReset) {
            this.shapeMode(3);
            this.scaleFactor = 1.0f;
            this.translateX = this.width / 2;
            this.translateY = this.height / 2;
        } else if (button == this.btnHelp) {
            this.screencast();
        } else if (button == this.btnWJEO) {
            this.wjeo();
        } else if (button == this.btnCloud) {
            this.cloud();
        } else if (button == this.btnZoomIn) {
            this.scaleFactor += 0.1f;
        } else if (button == this.btnZoomOut) {
            this.scaleFactor -= 0.1f;
        } else if (button == this.btnTextB) {
            ++this.fs;
        } else if (button == this.btnTextS && this.fs >= 15) {
            --this.fs;
        }
    }

    public void dropEvent(DropEvent theDropEvent) {
        this.myText = String.valueOf(this.myText) + theDropEvent.text();
    }

    public void settings() {
        this.size(1280, 720);
        this.smooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"JEViewer"};
        if (passedArgs != null) {
            PApplet.main((String[])JEViewer.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

